set encoding iso_8859_1
set terminal pdfcairo enhanced color font ",30" size 10, 6
set output 'sigma.pdf'
set border lw 2
set autoscale fix
set ylabel '{/Symbol s}_{xx}/{/Symbol t} (({/Symbol W}*m*s)^{-1})'
set xlabel 'B{/Symbol t} (T.ps)'
set key outside
set palette defined (0 'red', 1 'green')
unset colorbox
set ylabel offset 0.0,0
Tmin =   2.00
Tmax =  32.00
NumT =    4
OmegaMin =   0.00
OmegaMax =   0.00
OmegaNum =    1
lw =    4

#plot conductivity/tau
plot for [i=0:NumT-1] 'sigma_total_mu_0.00eV.dat' every :::i::i+1 u 1:2 w l lw lw lt palette frac i/(NumT*1.0)title sprintf('T=%.0f K', Tmin + (Tmax-Tmin)/(NumT*1.0-1.0)*i)
 
set ylabel '{/Symbol s}_{xy}/{/Symbol t} (({/Symbol W}*m*s)^{-1})'
plot for [i=0:NumT-1] 'sigma_total_mu_0.00eV.dat' every :::i::i+1 u 1:3 w l lw lw lt palette frac i/(NumT*1.0)title sprintf('T=%.0f K', Tmin + (Tmax-Tmin)/(NumT*1.0-1.0)*i)
 
#plot resistivity*tau
 
set ylabel '{/Symbol r}_{xx}*{/Symbol t} ({/Symbol W}*m*s)'
plot for [i=0:NumT-1] 'rho_total_mu_0.00eV.dat' every :::i::i+1 u 1:2 w l lw lw lt palette frac i/(NumT*1.0)title sprintf('T=%.0f K', Tmin + (Tmax-Tmin)/(NumT*1.0-1.0)*i)
 
set ylabel '{/Symbol r}_{yx}*{/Symbol t} ({/Symbol W}*m*s)'
plot for [i=0:NumT-1] 'rho_total_mu_0.00eV.dat' every :::i::i+1 u 1:5 w l lw lw lt palette frac i/(NumT*1.0)title sprintf('T=%.0f K', Tmin + (Tmax-Tmin)/(NumT*1.0-1.0)*i)
