
###PLOT RAW CC & DV COM VALUES

#FILE: Macaulay_BirdCoM_Plot_CoM.R

#CITATION: Macaulay, S. et al. XXXX. Decoupling body shape and mass distribution in birds and their dinosaurian ancestors
           
#CODE CREDITS: Built by Samuel Cross in R. 4.1.2

#DESCRIPTION: This code plots Figure 2a from Macaulay et al., the normalised craniocaudal and dorsoventral centre of
#             mass values, including different estimates for extinct taxa, as well as convex hulls and a legend. It 
#             does not include the silhouettes, which were sourced from Phylopic and manually added.


###Load Dependent Packages

library(xlsx)

###Load Data

data <- read.xlsx("Macaulay_BirdCoM_PCM_Dataset.xlsx", sheetIndex = 1)

###Organise Taxon Lists

Croc_Liz <- row.names(data)[data[,1] == 'Croc_Liz']
HLD_list <- row.names(data)[data[,1] == 'HLD']
FLD_list <- row.names(data)[data[,1] == 'FLD']
Allo_list <- row.names(data)[data[,1] == 'Allosaurus']
Archa_list <- row.names(data)[data[,1] == 'Archaeopteryx']
Anzu_list <- row.names(data)[data[,1] == 'Anzu']
Batra_list <- row.names(data)[data[,1] == 'Batrachotomus']
Coel_list <- row.names(data)[data[,1] == 'Coelophysis']
Dilo_list <- row.names(data)[data[,1] == 'Dilophosaurus']
Hetero_list <- row.names(data)[data[,1] == 'Heterodontosaurus']
Micro_list <- row.names(data)[data[,1] == 'Microraptor']
Plate_list <- row.names(data)[data[,1] == 'Plateosaurus']
Staur_list <- row.names(data)[data[,1] == 'Staurikosaurus']
Struth_list <- row.names(data)[data[,1] == 'Struthiomimus']
Rex_list <- row.names(data)[data[,1] == 'Tyrannosaurus']
Veloci_list <- row.names(data)[data[,1] == 'Velociraptor']
Yixian_list <- row.names(data)[data[,1] == 'Yixianornis']
Dino_list <- c(Allo_list, Archa_list, Anzu_list, Batra_list, Coel_list, Dilo_list, Hetero_list, Micro_list,
               Plate_list, Staur_list, Struth_list, Rex_list, Veloci_list, Yixian_list)

###Write Convex Hull Functions

#Function to convex hull a series of data points, taken from Cross et al., 2022.
Plot_ConvexHull<-function(xcoord, ycoord, bgcolor){
  hpts <- chull(x = xcoord, y = ycoord)
  hpts <- c(hpts, hpts[1])
  #lines(xcoord[hpts], ycoord[hpts], col = lcolor, lty = 5)
  polygon(x = xcoord[hpts], y =  ycoord[hpts], col = adjustcolor(bgcolor, alpha.f = 0.2) , border = NA)
}

#Modified variant to plot hulls around dino CoM estimates
Plot_ConvexHull_Dino<-function(xcoord, ycoord, bgcolor, lcolor){
  hpts <- chull(x = xcoord, y = ycoord)
  hpts <- c(hpts, hpts[1])
  lines(xcoord[hpts], ycoord[hpts], col = lcolor, lty = 5)
  polygon(x = xcoord[hpts], y =  ycoord[hpts], col = adjustcolor(bgcolor, alpha.f = 0.2) , border = NA)
}

###Plotting

tiff(filename = "CoM_Estimates.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600)

plot.new()

#Create blank plot of data
plot(data[,2], data[,3], axes = FALSE, ylab = "", xlab = "", pch = "")

#Manually draw axes so X is on the top
axis(3)
mtext("Craniocaudal CoM", side = 3, line = 3)
axis(2)
mtext("Dorsoventral CoM", side = 2, line = 3)

#Draw box around plot
box(which = "plot", lty = "solid")

#Draw hulls around living birds, unquote third command to include basal reptiles (excluded in published figure)
Plot_ConvexHull(xcoord=data[HLD_list,][,2],
                ycoord=data[HLD_list,][,3], bgcolor="red")
Plot_ConvexHull(xcoord=data[FLD_list,][,2],
                ycoord=data[FLD_list,][,3], bgcolor="blue")
#Plot_ConvexHull(xcoord=data[Croc_Liz,][,2],
                #ycoord=data[Croc_Liz,][,3], bgcolor="green")

#Draw hulls around CoM estimates for each extinct taxon
Plot_ConvexHull_Dino(xcoord=data[Allo_list,][,2],
                     ycoord=data[Allo_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Archa_list,][,2],
                     ycoord=data[Archa_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Anzu_list,][,2],
                     ycoord=data[Anzu_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Batra_list,][,2],
                     ycoord=data[Batra_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Coel_list,][,2],
                     ycoord=data[Coel_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Dilo_list,][,2],
                     ycoord=data[Dilo_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Hetero_list,][,2],
                     ycoord=data[Hetero_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Micro_list,][,2],
                     ycoord=data[Micro_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Plate_list,][,2],
                     ycoord=data[Plate_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Staur_list,][,2],
                     ycoord=data[Staur_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Struth_list,][,2],
                     ycoord=data[Struth_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Rex_list,][,2],
                     ycoord=data[Rex_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Veloci_list,][,2],
                     ycoord=data[Veloci_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))
Plot_ConvexHull_Dino(xcoord=data[Yixian_list,][,2],
                     ycoord=data[Yixian_list,][,3], bgcolor="", lcolor = c("black", "black", "black"))

#Plot CoM positions
points(data[Croc_Liz,][,2], data[Croc_Liz,][,3], cex = 1.4, pch = 21, col = "black", bg = "green")
points(data[HLD_list,][,2], data[HLD_list,][,3], cex = 1.4, pch = 21, col = "black", bg = "red")
points(data[FLD_list,][,2], data[FLD_list,][,3], cex = 1.4, pch = 21, col = "black", bg = "blue")
points(data[Dino_list,][,2], data[Dino_list,][,3], cex = 1, pch = 0, col = "black")

#overwrite the heterogeneous CoM estimates for extinct taxa with filled points
points(data[40,2], data[40,3], cex = 1.5, pch = 15, col = "black") #Allosaurus
points(data[44,2], data[44,3], cex = 1.5, pch = 15, col = "black") #Archaeopteryx
points(data[48,2], data[48,3], cex = 1.5, pch = 15, col = "black") #Anzu
points(data[52,2], data[52,3], cex = 1.5, pch = 22, col = "black", bg = "green") #Batrachotomus
points(data[56,2], data[56,3], cex = 1.5, pch = 15, col = "black") #Coelophysis
points(data[60,2], data[60,3], cex = 1.5, pch = 15, col = "black") #Dilophosaurus
points(data[64,2], data[64,3], cex = 1.5, pch = 15, col = "black") #Heterodontosaurus
points(data[68,2], data[68,3], cex = 1.5, pch = 15, col = "black") #Microraptor
points(data[72,2], data[72,3], cex = 1.5, pch = 15, col = "black") #Plateosaurus
points(data[76,2], data[76,3], cex = 1.5, pch = 15, col = "black") #Staurikosaurus
points(data[80,2], data[80,3], cex = 1.5, pch = 15, col = "black") #Struthiomimus
points(data[84,2], data[84,3], cex = 1.5, pch = 15, col = "black") #Tyrannosaurus
points(data[88,2], data[88,3], cex = 1.5, pch = 15, col = "black") #Velociraptor
points(data[92,2], data[92,3], cex = 1.5, pch = 15, col = "black") #Yixianornis

#write legend
legend(140, 0, legend=c("FLD birds", "HLD birds", "NA dinosaurs", "NA sauropsids", "Extinct", "Extant"),
       col=c("black", "black", "black", "black"), pch = c(21, 21, 21, 21, 0, 1), cex=0.8, pt.bg = c("blue", "red", "black", "green"))

dev.off()


