
###Ancestral State Estimation

#FILE: Macaulay_BirdCoM_AncestralStates.R

#CITATION: Macaulay, S. et al. XXXX. Decoupling body shape and mass distribution in birds and their dinosaurian ancestors

#CODE CREDITS: Built by Samuel Cross in R. 4.1.2

#DESCRIPTION: This code performs ancestral state estimation for the centre of mass positions, segment volumes, and segment lengths.


###Load Dependent Packages

library(xlsx)
library(ape)
library(geiger)
library(phytools)

###Load Data

Data.Het <- read.xlsx("Macaulay_BirdCoM_PCM_Dataset.xlsx", sheetIndex = 2, row.names = 1)
Data.Het[Data.Het == "NA"] <- 0.001
Data.Lin <- read.xlsx("Macaulay_BirdCoM_PCM_Dataset.xlsx", sheetIndex = 3, row.names = 1)

###Load tree

tree <- read.tree("Macaulay_BirdCoM_PCM_Tree.tre") #Change to use other trees/time-scaling methods

###Check Data & tree compatbility

identical(tree$tip.label,rownames(Data.Het))
name.check(tree,rownames(Data.Het))
Data.Het <- Data.Het[match(tree$tip.label,rownames(Data.Het)),]

identical(tree$tip.label,rownames(Data.Lin))
name.check(tree,rownames(Data.Lin))
Data.Lin <- Data.Lin[match(tree$tip.label,rownames(Data.Lin)),]

###Extract parameters to analyse

#CoM positions
Data.Het.CoM.DV <- as.vector(Data.Het[, 'DVnorm'])
names(Data.Het.CoM.DV) <- rownames(Data.Het)
Data.Het.CoM.CC <- Data.Het[, 'CCnorm']
names(Data.Het.CoM.CC) <- rownames(Data.Het)

#Segment masses
Data.Het.Head <- Data.Het[, 'Head_Mass']
names(Data.Het.Head) <- rownames(Data.Het)
Data.Het.Neck <- Data.Het[, 'Neck_Mass']
names(Data.Het.Neck) <- rownames(Data.Het)
Data.Het.Torso <- Data.Het[, 'Torso_Mass']
names(Data.Het.Torso) <- rownames(Data.Het)
Data.Het.Humeral <- Data.Het[, 'Humeral_Mass']
names(Data.Het.Humeral) <- rownames(Data.Het)
Data.Het.Forearm <- Data.Het[, 'Forearm_Mass']
names(Data.Het.Forearm) <- rownames(Data.Het)
Data.Het.Hand <- Data.Het[, 'Hand_Mass']
names(Data.Het.Hand) <- rownames(Data.Het)
Data.Het.Thigh <- Data.Het[, 'Thigh_Mass']
names(Data.Het.Thigh) <- rownames(Data.Het)
Data.Het.Shank <- Data.Het[, 'Shank_Mass']
names(Data.Het.Shank) <- rownames(Data.Het)
Data.Het.MT <- Data.Het[, 'MT_Mass']
names(Data.Het.MT) <- rownames(Data.Het)
Data.Het.Pes <- Data.Het[, 'Pes_Mass']
names(Data.Het.Pes) <- rownames(Data.Het)
Data.Het.Hindlimb <- Data.Het[, 'Hindlimb_Mass']
names(Data.Het.Hindlimb) <- rownames(Data.Het)
Data.Het.Forelimb <- Data.Het[, 'Forelimb_Mass']
names(Data.Het.Forelimb) <- rownames(Data.Het)
Data.Het.Tail <- Data.Het[, 'Tail_Mass']
names(Data.Het.Tail) <- rownames(Data.Het)

#Segment lengths
Data.Lin.Pelvic.Width <- Data.Lin[, 'PelvicWidth']
names(Data.Lin.Pelvic.Width) <- rownames(Data.Lin)
Data.Lin.Pelvic.Length <- Data.Lin[, 'PelvicLength']
names(Data.Lin.Pelvic.Length) <- rownames(Data.Lin)
Data.Lin.Shoulder.Width <- Data.Lin[, 'ShoulderWidth']
names(Data.Lin.Shoulder.Width) <- rownames(Data.Lin)
Data.Lin.Neck.Length <- Data.Lin[, 'NeckLength']
names(Data.Lin.Neck.Length) <- rownames(Data.Lin)
Data.Lin.Skull.Length <- Data.Lin[, 'SkullLength']
names(Data.Lin.Skull.Length) <- rownames(Data.Lin)
Data.Lin.Hindlimb.Length <- Data.Lin[, 'HindlimbLength']
names(Data.Lin.Hindlimb.Length) <- rownames(Data.Lin)
Data.Lin.Forelimb.Length <- Data.Lin[, 'ForelimbLength']
names(Data.Lin.Forelimb.Length) <- rownames(Data.Lin)
Data.Lin.GA.Length <- Data.Lin[, 'GALength']
names(Data.Lin.GA.Length) <- rownames(Data.Lin)
Data.Lin.Tail.Length <- Data.Lin[, 'TailLength']
names(Data.Lin.Tail.Length) <- rownames(Data.Lin)
Data.Lin.Femur.Length <- Data.Lin[, 'FemurLength']
names(Data.Lin.Femur.Length) <- rownames(Data.Lin)
Data.Lin.Shank.Length <- Data.Lin[, 'ShankLength']
names(Data.Lin.Shank.Length) <- rownames(Data.Lin)
Data.Lin.MT.Length <- Data.Lin[, 'MTLength']
names(Data.Lin.MT.Length) <- rownames(Data.Lin)

###Ancestral State Reconstruction using FastANC

#CoM estimations
Data.Het.CoM.DV.ANC <- fastAnc(tree, Data.Het.CoM.DV, vars=T, CI=T)
#Data.Het.CoM.DV.Plot <- contMap(tree, Data.Het.CoM.DV, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.CoM.DV.ANC)
#Data.Het.CoM.DV.Plot

Data.Het.CoM.CC.ANC <- fastAnc(tree, Data.Het.CoM.CC, vars=T, CI=T)
#Data.Het.CoM.CC.Plot <- contMap(tree, Data.Het.CoM.CC, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.CoM.CC.ANC)
#Data.Het.CoM.CC.Plot

#Export spreadsheet of results
Data.Het.CoM.DV.ANC.Res <- c(Data.Het.CoM.DV.ANC['ace'], Data.Het.CoM.DV.ANC['CI95'])
write.xlsx(Data.Het.CoM.DV.ANC.Res, "ANC_CoM.xlsx", sheetName = "Het_Norm_CoM_DV", col.names = T, row.names = T)
Data.Het.CoM.CC.ANC.Res <- c(Data.Het.CoM.CC.ANC['ace'], Data.Het.CoM.CC.ANC['CI95'])
write.xlsx(Data.Het.CoM.CC.ANC.Res, "ANC_CoM.xlsx", sheetName = "Het_Norm_CoM_CC", col.names = T, row.names = T, append = T)

#Segment masses
Data.Het.Head.ANC <- fastAnc(tree, Data.Het.Head, vars=T, CI=T)
#Data.Het.Head.Plot <- contMap(tree, Data.Het.Head, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Head.ANC)
#Data.Het.Head.Plot

Data.Het.Neck.ANC <- fastAnc(tree, Data.Het.Neck, vars=T, CI=T)
#Data.Het.Neck.Plot <- contMap(tree, Data.Het.Neck, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Neck.ANC)
#Data.Het.Neck.Plot

Data.Het.Torso.ANC <- fastAnc(tree, Data.Het.Torso, vars=T, CI=T)
#Data.Het.Torso.Plot <- contMap(tree, Data.Het.Torso, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Torso.ANC)
#Data.Het.Torso.Plot

Data.Het.Humeral.ANC <- fastAnc(tree, Data.Het.Humeral, vars=T, CI=T)
#Data.Het.Humeral.Plot <- contMap(tree, Data.Het.Humeral, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Humeral.ANC)
#Data.Het.Humeral.Plot

Data.Het.Forearm.ANC <- fastAnc(tree, Data.Het.Forearm, vars=T, CI=T)
#Data.Het.Forearm.Plot <- contMap(tree, Data.Het.Forearm, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Forearm.ANC)
#Data.Het.Forearm.Plot

Data.Het.Hand.ANC <- fastAnc(tree, Data.Het.Hand, vars=T, CI=T)
#Data.Het.Hand.Plot <- contMap(tree, Data.Het.Hand, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Hand.ANC)
#Data.Het.Hand.Plot

Data.Het.Thigh.ANC <- fastAnc(tree, Data.Het.Thigh, vars=T, CI=T)
#Data.Het.Thigh.Plot <- contMap(tree, Data.Het.Thigh, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Thigh.ANC)
#Data.Het.Thigh.Plot

Data.Het.Shank.ANC <- fastAnc(tree, Data.Het.Shank, vars=T, CI=T)
#Data.Het.Shank.Plot <- contMap(tree, Data.Het.Shank, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Shank.ANC)
#Data.Het.Shank.Plot

Data.Het.MT.ANC <- fastAnc(tree, Data.Het.MT, vars=T, CI=T)
#Data.Het.MT.Plot <- contMap(tree, Data.Het.MT, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.MT.ANC)
#Data.Het.MT.Plot

Data.Het.Pes.ANC <- fastAnc(tree, Data.Het.Pes, vars=T, CI=T)
#Data.Het.Pes.Plot <- contMap(tree, Data.Het.Pes, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Pes.ANC)
#Data.Het.Pes.Plot

Data.Het.Hindlimb.ANC <- fastAnc(tree, Data.Het.Hindlimb, vars=T, CI=T)
#Data.Het.Hindlimb.Plot <- contMap(tree, Data.Het.Hindlimb, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Hindlimb.ANC)
#Data.Het.Hindlimb.Plot

Data.Het.Forelimb.ANC <- fastAnc(tree, Data.Het.Forelimb, vars=T, CI=T)
#Data.Het.Forelimb.Plot <- contMap(tree, Data.Het.Forelimb, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Forelimb.ANC)
#Data.Het.Forelimb.Plot

Data.Het.Tail.ANC <- fastAnc(tree, Data.Het.Tail, vars=T, CI=T)
#Data.Het.Tail.Plot <- contMap(tree, Data.Het.Tail, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Het.Tail.ANC)
#Data.Het.Tail.Plot

#Export spreadsheet of results
Data.Het.Head.ANC.Res <- c(Data.Het.Head.ANC['ace'], Data.Het.Head.ANC['CI95'])
write.xlsx(Data.Het.Head.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Head", col.names = T, row.names = T)
Data.Het.Neck.ANC.Res <- c(Data.Het.Neck.ANC['ace'], Data.Het.Neck.ANC['CI95'])
write.xlsx(Data.Het.Neck.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Neck", col.names = T, row.names = T, append = T)
Data.Het.Torso.ANC.Res <- c(Data.Het.Torso.ANC['ace'], Data.Het.Torso.ANC['CI95'])
write.xlsx(Data.Het.Torso.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Torso", col.names = T, row.names = T, append = T)
Data.Het.Humeral.ANC.Res <- c(Data.Het.Humeral.ANC['ace'], Data.Het.Humeral.ANC['CI95'])
write.xlsx(Data.Het.Humeral.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Humeral", col.names = T, row.names = T, append = T)
Data.Het.Forearm.ANC.Res <- c(Data.Het.Forearm.ANC['ace'], Data.Het.Forearm.ANC['CI95'])
write.xlsx(Data.Het.Forearm.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Forearm", col.names = T, row.names = T, append = T)
Data.Het.Hand.ANC.Res <- c(Data.Het.Hand.ANC['ace'], Data.Het.Hand.ANC['CI95'])
write.xlsx(Data.Het.Hand.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Hand", col.names = T, row.names = T, append = T)
Data.Het.Thigh.ANC.Res <- c(Data.Het.Thigh.ANC['ace'], Data.Het.Thigh.ANC['CI95'])
write.xlsx(Data.Het.Thigh.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Thigh", col.names = T, row.names = T, append = T)
Data.Het.Shank.ANC.Res <- c(Data.Het.Shank.ANC['ace'], Data.Het.Shank.ANC['CI95'])
write.xlsx(Data.Het.Shank.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Shank", col.names = T, row.names = T, append = T)
Data.Het.MT.ANC.Res <- c(Data.Het.MT.ANC['ace'], Data.Het.MT.ANC['CI95'])
write.xlsx(Data.Het.MT.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_MT", col.names = T, row.names = T, append = T)
Data.Het.Pes.ANC.Res <- c(Data.Het.Pes.ANC['ace'], Data.Het.Pes.ANC['CI95'])
write.xlsx(Data.Het.Pes.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Pes", col.names = T, row.names = T, append = T)
Data.Het.Hindlimb.ANC.Res <- c(Data.Het.Hindlimb.ANC['ace'], Data.Het.Hindlimb.ANC['CI95'])
write.xlsx(Data.Het.Hindlimb.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Hindlimb", col.names = T, row.names = T, append = T)
Data.Het.Forelimb.ANC.Res <- c(Data.Het.Forelimb.ANC['ace'], Data.Het.Forelimb.ANC['CI95'])
write.xlsx(Data.Het.Forelimb.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Forelimb", col.names = T, row.names = T, append = T)
Data.Het.Tail.ANC.Res <- c(Data.Het.Tail.ANC['ace'], Data.Het.Tail.ANC['CI95'])
write.xlsx(Data.Het.Tail.ANC.Res, "ANC_Segs.xlsx", sheetName = "Het_Norm_Tail", col.names = T, row.names = T, append = T)

#Segment lengths
Data.Lin.Pelvic.Width.ANC <- fastAnc(tree, Data.Lin.Pelvic.Width, vars=T, CI=T)
#Data.Lin.Pelvic.Width.Plot <- contMap(tree, Data.Lin.Pelvic.Width, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.Pelvic.Width.ANC)
#Data.Lin.Pelvic.Width.Plot

Data.Lin.Pelvic.Length.ANC <- fastAnc(tree, Data.Lin.Pelvic.Length, vars=T, CI=T)
#Data.Lin.Pelvic.Length.Plot <- contMap(tree, Data.Lin.Pelvic.Length, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.Pelvic.Length.ANC)
#Data.Lin.Pelvic.Length.Plot

Data.Lin.Shoulder.Width.ANC <- fastAnc(tree, Data.Lin.Shoulder.Width, vars=T, CI=T)
#Data.Lin.Shoulder.Width.Plot <- contMap(tree, Data.Lin.Shoulder.Width, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.Shoulder.Width.ANC)
#Data.Lin.Shoulder.Width.Plot

Data.Lin.Neck.Length.ANC <- fastAnc(tree, Data.Lin.Neck.Length, vars=T, CI=T)
#Data.Lin.Neck.Length.Plot <- contMap(tree, Data.Lin.Neck.Length, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.Neck.Length.ANC)
#Data.Lin.Neck.Length.Plot

Data.Lin.Skull.Length.ANC <- fastAnc(tree, Data.Lin.Skull.Length, vars=T, CI=T)
#Data.Lin.Skull.Length.Plot <- contMap(tree, Data.Lin.Skull.Length, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.Skull.Length.ANC)
#Data.Lin.Skull.Length.Plot

Data.Lin.Hindlimb.Length.ANC <- fastAnc(tree, Data.Lin.Hindlimb.Length, vars=T, CI=T)
#Data.Lin.Hindlimb.Length.Plot <- contMap(tree, Data.Lin.Hindlimb.Length, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.Hindlimb.Length.ANC)
#Data.Lin.Hindlimb.Length.Plot

Data.Lin.Forelimb.Length.ANC <- fastAnc(tree, Data.Lin.Forelimb.Length, vars=T, CI=T)
#Data.Lin.Forelimb.Length.Plot <- contMap(tree, Data.Lin.Forelimb.Length, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.Forelimb.Length.ANC)
#Data.Lin.Forelimb.Length.Plot

Data.Lin.GA.Length.ANC <- fastAnc(tree, Data.Lin.GA.Length, vars=T, CI=T)
#Data.Lin.GA.Length.Plot <- contMap(tree, Data.Lin.GA.Length, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.GA.Length.ANC)
#Data.Lin.GA.Length.Plot

Data.Lin.Tail.Length.ANC <- fastAnc(tree, Data.Lin.Tail.Length, vars=T, CI=T)
#Data.Lin.Tail.Length.Plot <- contMap(tree, Data.Lin.Tail.Length, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.Tail.Length.ANC)
#Data.Lin.Tail.Length.Plot

Data.Lin.Femur.Length.ANC <- fastAnc(tree, Data.Lin.Femur.Length, vars=T, CI=T)
#Data.Lin.Femur.Length.Plot <- contMap(tree, Data.Lin.Femur.Length, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.Femur.Length.ANC)
#Data.Lin.Femur.Length.Plot

Data.Lin.Shank.Length.ANC <- fastAnc(tree, Data.Lin.Shank.Length, vars=T, CI=T)
#Data.Lin.Shank.Length.Plot <- contMap(tree, Data.Lin.Shank.Length, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.Shank.Length.ANC)
#Data.Lin.Shank.Length.Plot

Data.Lin.MT.Length.ANC <- fastAnc(tree, Data.Lin.MT.Length, vars=T, CI=T)
#Data.Lin.MT.Length.Plot <- contMap(tree, Data.Lin.MT.Length, plot=TRUE, legend = FALSE, fsize = c(0,2))
#print(Data.Lin.MT.Length.ANC)
#Data.Lin.MT.Length.Plot

#Export spreadsheet of results
Data.Lin.Pelvic.Width.ANC.Res <- c(Data.Lin.Pelvic.Width.ANC['ace'], Data.Lin.Pelvic.Width.ANC['CI95'])
write.xlsx(Data.Lin.Pelvic.Width.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_PelvicWidth", col.names = T, row.names = T)
Data.Lin.Pelvic.Length.ANC.Res <- c(Data.Lin.Pelvic.Length.ANC['ace'], Data.Lin.Pelvic.Length.ANC['CI95'])
write.xlsx(Data.Lin.Pelvic.Length.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_PelvicLength", col.names = T, row.names = T, append = T)
Data.Lin.Shoulder.Width.ANC.Res <- c(Data.Lin.Shoulder.Width.ANC['ace'], Data.Lin.Shoulder.Width.ANC['CI95'])
write.xlsx(Data.Lin.Shoulder.Width.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_ShoulderWidth", col.names = T, row.names = T, append = T)
Data.Lin.Neck.Length.ANC.Res <- c(Data.Lin.Neck.Length.ANC['ace'], Data.Lin.Neck.Length.ANC['CI95'])
write.xlsx(Data.Lin.Neck.Length.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_NeckLength", col.names = T, row.names = T, append = T)
Data.Lin.Skull.Length.ANC.Res <- c(Data.Lin.Skull.Length.ANC['ace'], Data.Lin.Skull.Length.ANC['CI95'])
write.xlsx(Data.Lin.Skull.Length.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_SkullLength", col.names = T, row.names = T, append = T)
Data.Lin.Hindlimb.Length.ANC.Res <- c(Data.Lin.Hindlimb.Length.ANC['ace'], Data.Lin.Hindlimb.Length.ANC['CI95'])
write.xlsx(Data.Lin.Hindlimb.Length.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_HindLength", col.names = T, row.names = T, append = T)
Data.Lin.Forelimb.Length.ANC.Res <- c(Data.Lin.Forelimb.Length.ANC['ace'], Data.Lin.Forelimb.Length.ANC['CI95'])
write.xlsx(Data.Lin.Forelimb.Length.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_ForeLength", col.names = T, row.names = T, append = T)
Data.Lin.GA.Length.ANC.Res <- c(Data.Lin.GA.Length.ANC['ace'], Data.Lin.GA.Length.ANC['CI95'])
write.xlsx(Data.Lin.GA.Length.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_GALength", col.names = T, row.names = T, append = T)
Data.Lin.Tail.Length.ANC.Res <- c(Data.Lin.Tail.Length.ANC['ace'], Data.Lin.Tail.Length.ANC['CI95'])
write.xlsx(Data.Lin.Tail.Length.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_TailLength", col.names = T, row.names = T, append = T)
Data.Lin.Femur.Length.ANC.Res <- c(Data.Lin.Femur.Length.ANC['ace'], Data.Lin.Femur.Length.ANC['CI95'])
write.xlsx(Data.Lin.Femur.Length.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_FemurLength", col.names = T, row.names = T, append = T)
Data.Lin.Shank.Length.ANC.Res <- c(Data.Lin.Shank.Length.ANC['ace'], Data.Lin.Shank.Length.ANC['CI95'])
write.xlsx(Data.Lin.Shank.Length.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_ShankLength", col.names = T, row.names = T, append = T)
Data.Lin.MT.Length.ANC.Res <- c(Data.Lin.MT.Length.ANC['ace'], Data.Lin.MT.Length.ANC['CI95'])
write.xlsx(Data.Lin.MT.Length.ANC.Res, "ANC_Lin.xlsx", sheetName = "Lin_Norm_MTLength", col.names = T, row.names = T, append = T)