setwd("~/Desktop/BirdCoM_MatlabStats/ForRyan/Karl_NewMasterDataFiles_March2021/Part2")

### Required packages ####
require(nlme)
require(ape)
require(qpcR)
require(ggplot2)
require(ggalt)
require(phytools)
require(geiger)

### Load the data ####
metadataall <- read.csv("CoM_part2all.csv")
metadatabirds <- read.csv("CoM_part2birds.csv")
metadatacl <- read.csv("CoM_part2crocslizards.csv")
trees <- read.nexus("output.nex") ### Reads Jetz tree distribution based on Hackett backbone
trees <- lapply(trees , ladderize, right = F) ### Ladderizes nodes in trees for plotting etc.
cltrees <- read.nexus("cltrees.nex")
cltrees <- lapply(cltrees , ladderize, right = F) ### Ladderizes nodes in trees for plotting etc.
alltrees <- read.nexus("alltrees.nex")
alltrees <- lapply(alltrees , ladderize, right = F) ### Ladderizes nodes in trees for plotting etc.

### Prepping the data for analysis ####

allTREE.temp <- alltrees
  alldrop.taxa <- allTREE.temp$tip.label[ is.na( match( allTREE.temp $ tip.label , metadataall $ TreeNames ) ) ]
    allTREE.temp <- drop.tip( allTREE.temp , alldrop.taxa )

    metadataall <- metadataall[ match( allTREE.temp $ tip.label , metadataall $ TreeNames ) , ]
      rownames( metadataall ) <- metadataall $ TreeNames

dfall <- data.frame (species = metadataall$TreeNames,
                     phylo = metadataall$phylo,
                       headskinvol = log10(metadataall$Head_SkinVol),
                       neckskinvol = log10(metadataall$Neck_SkinVol),
                       torsoskinvol = log10(metadataall$Torso_SkinVol),
                       humeralskinvol = log10(metadataall$Humeral_SkinVol),
                       forearmskinvol = log10(metadataall$Forearm_SkinVol),
                       handskinvol = log10(metadataall$Hand_SkinVol),
                       thighskinvol = log10(metadataall$Thigh_SkinVol),
                       shankskinvol = log10(metadataall$Shank_SkinVol),
                       mtskinvol = log10(metadataall$MT_SkinVol),
                       pesskinvol = log10(metadataall$Pes_SkinVol),
                       hindlimbskinvol = log10(metadataall$Hindlimb_SkinVol),
                       forelimbskinvol = log10(metadataall$Forelimb_SkinVol),
                       modelskinvol = log10(metadataall$ModelSkinVol),
                       headcvhvol = log10(metadataall$Head_CVHVol),
                       neckcvhvol = log10(metadataall$Neck_CVHVol),
                       torsocvhvol = log10(metadataall$Torso_CVHVol),
                       humeralcvhvol = log10(metadataall$Humeral_CVHVol),
                       forearmcvhvol = log10(metadataall$Forearm_CVHVol),
                       handcvhvol = log10(metadataall$Hand_CVHVol),
                       thighcvhvol = log10(metadataall$Thigh_CVHVol),
                       shankcvhvol = log10(metadataall$Shank_CVHVol),
                       mtcvhvol = log10(metadataall$MT_CVHVol),
                       pescvhvol = log10(metadataall$Pes_CVHVol),
                       hindlimbcvhvol = log10(metadataall$Hindlimb_CVHVol),
                       forelimbcvhvol = log10(metadataall$Forelimb_CVHVol),
                       wholebody = log10(metadataall$WholeBody)
)


  allTREE.temp <- alltrees
    alldrop.taxa <- allTREE.temp$tip.label[ is.na( match( allTREE.temp $ tip.label , metadatabirds $ TreeNames ) ) ]
      allTREE.temp <- drop.tip( allTREE.temp , alldrop.taxa )

      metadatabirds <- metadatabirds[ match( allTREE.temp $ tip.label , metadatabirds $ TreeNames ) , ]
        rownames( metadatabirds ) <- metadatabirds $ BirdTree_names
        
dfbirds <- data.frame (species = metadatabirds$TreeNames,
                       headskinvol = log10(metadatabirds$Head_SkinVol),
                       neckskinvol = log10(metadatabirds$Neck_SkinVol),
                       torsoskinvol = log10(metadatabirds$Torso_SkinVol),
                       humeralskinvol = log10(metadatabirds$Humeral_SkinVol),
                       forearmskinvol = log10(metadatabirds$Forearm_SkinVol),
                       handskinvol = log10(metadatabirds$Hand_SkinVol),
                       thighskinvol = log10(metadatabirds$Thigh_SkinVol),
                       shankskinvol = log10(metadatabirds$Shank_SkinVol),
                       mtskinvol = log10(metadatabirds$MT_SkinVol),
                       pesskinvol = log10(metadatabirds$Pes_SkinVol),
                       hindlimbskinvol = log10(metadatabirds$Hindlimb_SkinVol),
                       forelimbskinvol = log10(metadatabirds$Forelimb_SkinVol),
                       modelskinvol = log10(metadatabirds$ModelSkinVol),
                       headcvhvol = log10(metadatabirds$Head_CVHVol),
                       neckcvhvol = log10(metadatabirds$Neck_CVHVol),
                       torsocvhvol = log10(metadatabirds$Torso_CVHVol),
                       humeralcvhvol = log10(metadatabirds$Humeral_CVHVol),
                       forearmcvhvol = log10(metadatabirds$Forearm_CVHVol),
                       handcvhvol = log10(metadatabirds$Hand_CVHVol),
                       thighcvhvol = log10(metadatabirds$Thigh_CVHVol),
                       shankcvhvol = log10(metadatabirds$Shank_CVHVol),
                       mtcvhvol = log10(metadatabirds$MT_CVHVol),
                       pescvhvol = log10(metadatabirds$Pes_CVHVol),
                       hindlimbcvhvol = log10(metadatabirds$Hindlimb_CVHVol),
                       forelimbcvhvol = log10(metadatabirds$Forelimb_CVHVol),
                       wholebody = log10(metadatabirds$WholeBody)
                       )

i = 1 ### Making sure the tree matches up with the species list in metadatacl ###
  clTREE.temp <- cltrees
    drop.taxa <- clTREE.temp$tip.label[ is.na( match( clTREE.temp $ tip.label , metadatacl $ TreeNames ) ) ]
      clTREE.temp <- drop.tip( clTREE.temp , drop.taxa )

      metadatacl <- metadatacl[ match( clTREE.temp $ tip.label , metadatacl $ TreeNames ) , ]
        rownames( metadatacl ) <- metadatacl $ TreeNames

dfcl <- data.frame (species = metadatacl$TreeNames,
                       headskinvol = log10(metadatacl$Head_SkinVol),
                       neckskinvol = log10(metadatacl$Neck_SkinVol),
                       torsoskinvol = log10(metadatacl$Torso_SkinVol),
                       tailskinvol = log10(metadatacl$Tail_SkinVol),  
                       humeralskinvol = log10(metadatacl$Humeral_SkinVol),
                       forearmskinvol = log10(metadatacl$Forearm_SkinVol),
                       handskinvol = log10(metadatacl$Hand_SkinVol),
                       thighskinvol = log10(metadatacl$Thigh_SkinVol),
                       shankskinvol = log10(metadatacl$Shank_SkinVol),
                       mtskinvol = log10(metadatacl$MT_SkinVol),
                       pesskinvol = log10(metadatacl$Pes_SkinVol),
                       hindlimbskinvol = log10(metadatacl$Hindlimb_SkinVol),
                       forelimbskinvol = log10(metadatacl$Forelimb_SkinVol),
                       modelskinvol = log10(metadatacl$ModeSkinVol),
                       headcvhvol = log10(metadatacl$Head_CVHVol),
                       neckcvhvol = log10(metadatacl$Neck_CVHVol),
                       torsocvhvol = log10(metadatacl$Torso_CVHVol),
                       tailcvhvol = log10(metadatacl$Tail_CVHVol),
                       humeralcvhvol = log10(metadatacl$Humeral_CVHVol),
                       forearmcvhvol = log10(metadatacl$Forearm_CVHVol),
                       handcvhvol = log10(metadatacl$Hand_CVHVol),
                       thighcvhvol = log10(metadatacl$Thigh_CVHVol),
                       shankcvhvol = log10(metadatacl$Shank_CVHVol),
                       mtcvhvol = log10(metadatacl$MT_CVHVol),
                       pescvhvol = log10(metadatacl$Pes_CVHVol),
                       hindlimbcvhvol = log10(metadatacl$Hindlimb_CVHVol),
                       forelimbcvhvol = log10(metadatacl$Forelimb_CVHVol),
                       wholebody = log10(metadatacl$Whole.body.CVHVol)
)

dfbirdsthigh <- dfbirds[-c(12, 20),]
 ### Making sure the tree matches up with the species list in dfbirdsthigh ###
  thighTREE.temp <- alltrees
    thighdrop.taxa <- thighTREE.temp$tip.label[ is.na( match( thighTREE.temp $ tip.label , dfbirdsthigh $ species ) ) ]
      thighTREE.temp <- drop.tip( thighTREE.temp , thighdrop.taxa )

dfbirdspes <- dfbirds[-c(15),]
 ### Making sure the tree matches up with the species list in dfbirdspes ###
  pesTREE.temp <- alltrees
    pesdrop.taxa <- pesTREE.temp$tip.label[ is.na( match( pesTREE.temp $ tip.label , dfbirdspes $ species ) ) ]
      pesTREE.temp <- drop.tip( pesTREE.temp , pesdrop.taxa )

dfcltail <- dfcl[-c(6, 9),]
 cltailTREE.temp <- cltrees ### Making sure the tree matches up with the species list in dfcltail ###
    cltaildrop.taxa <- cltailTREE.temp$tip.label[ is.na( match( cltailTREE.temp $ tip.label , dfcltail $ species ) ) ]
      cltailTREE.temp <- drop.tip( cltailTREE.temp , cltaildrop.taxa )
      
dfclhand <- dfcl[-c(16),]
  clhandTREE.temp <- cltrees ### Making sure the tree matches up with the species list in dfclhand ###
    clhanddrop.taxa <- clhandTREE.temp$tip.label[ is.na( match( clhandTREE.temp $ tip.label , dfclhand $ species ) ) ]
      clhandTREE.temp <- drop.tip( clhandTREE.temp , clhanddrop.taxa )
      
dfallthigh <- dfall[-c(22, 30),]
  allthighTREE.temp <- alltrees ### Making sure the tree matches up with the species list in dfallthigh ###
    allthighdrop.taxa <- allthighTREE.temp$tip.label[ is.na( match( allthighTREE.temp $ tip.label , dfallthigh $ species ) ) ]
      allthighTREE.temp <- drop.tip( allthighTREE.temp , allthighdrop.taxa )

dfallpes <- dfall[-c(25),]
  allpesTREE.temp <- alltrees ### Making sure the tree matches up with the species list in dfallpes ###
    allpesdrop.taxa <- allpesTREE.temp$tip.label[ is.na( match( allpesTREE.temp $ tip.label , dfallpes $ species ) ) ]
      allpesTREE.temp <- drop.tip( allpesTREE.temp , allpesdrop.taxa )
      
dfallhand <- dfall[-c(48),]
  allhandTREE.temp <- alltrees ### Making sure the tree matches up with the species list in dfallhand ###
    allhanddrop.taxa <- allhandTREE.temp$tip.label[ is.na( match( allhandTREE.temp $ tip.label , dfallhand $ species ) ) ]
      allhandTREE.temp <- drop.tip( allhandTREE.temp , allhanddrop.taxa )
      
      
### Creating the glsTable function ####

#Function to make pgls results table from set of gls results. Requires input of both the model of interest and the null model for comparison. Computes R2 using Nagelkerke's genearlised R2.
#Roger Benson 16 January 2020

require( nlme )
library( qpcR )

glsTable <- function( fit , null , roundC = 3 , roundP = 4 , lambda = c( 0 , 1 , "get" )[ 1 ] ) {
  
  coef <- cbind( round( summary(fit)$tTable[ , c(1,2,3) ] , roundC ) , round( summary(fit)$tTable[ , c(4) ] , roundP ) )
  colnames( coef )[ 4 ] <- "p value"
  
  model <- summary(fit)$call[[ 2 ]]
  model <- paste( model )
  model <- model[ -1 ]
  model <- paste( model[ 1 ] , "~" , model[ 2 ] )
  
  N <- fit$dims$N
  R2 <- round( 1-exp(-1*2/ N * ( fit $ logLik - null $ logLik ) ) , roundC )
  aicc <- round( AICc( fit ) , roundC )
  
  line.temp <- c( model , N , aicc , R2 )
  if( lambda == "get" ){ line.temp <- c( line.temp , round( fit$modelStruct[[1]][1] , roundC ) )
  }	else	{ line.temp <- c( line.temp , lambda ) }
  
  
  model.out <- matrix( ncol = length( line.temp ) , nrow = nrow( coef ) )
  model.out[ 1 , ] <- line.temp
  colnames( model.out ) <- c( "model" , "N" , "AICc" , "R2" , "lambda" )
  out <- cbind( model.out , coef )
  
  out
}




### Bird models ####

right.sides <- c("1", "thighcvhvol")
  models <- paste( "thighskinvol ~" , right.sides ) ### Enter CC or DV on left side of equation here ###
    models <- lapply( models , as.formula )
    
### pGLS right side must cvh vol, other one is skinvol###

gls.fit.list <- list()			
for( i in 1:length( models ) ) {
  start.lambda <- 0
    gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfbirdsthigh , correlation = corPagel( start.lambda , thighTREE.temp ) ) )
    while( length( gls.fit.list[[ i ]] ) == 1 ) {
      start.lambda = start.lambda + 0.05
      gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfbirdsthigh , correlation = corPagel( start.lambda , thighTREE.temp ) ) )						
    }
    names( gls.fit.list )[i] <- as.character( models[i] )
  } 

gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] , lambda = "get" )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]

for( i in 1:length(gls.tables.list) ){
  gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
}

write.csv( do.call( rbind , gls.tables.list ) , file = "CoM_part2_birdsThighpGLS.csv" )

### OLS rightside muscle cvh vol, other is skin vol###

right.sides <- c("1", "thighcvhvol")
  models <- paste( "thighskinvol ~" , right.sides ) ### Enter CC or DV on left side of equation here ###
    models <- lapply( models , as.formula )

gls.fit.list <- list()			
for( i in 1:length( models ) ) {
  gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfbirdsthigh ) )
  while( length( gls.fit.list[[ i ]] ) == 1 ) {
    gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfbirdsthigh ) )						
  }
  names( gls.fit.list )[i] <- as.character( models[i] )
} 

gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]

for( i in 1:length(gls.tables.list) ){
  gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
}

write.csv( do.call( rbind , gls.tables.list ) , file = "CoM_part2_birdsThighOLS.csv" )

### Croc & lizard models ####

### pGLS ###
right.sides <- c("1", "tailcvhvol")
  models <- paste( "tailskinvol ~" , right.sides ) 
    models <- lapply( models , as.formula )

gls.fit.list <- list()			
for( i in 1:length( models ) ) {
  start.lambda <- 0
  gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfcltail , correlation = corPagel( start.lambda , cltailTREE.temp ) ) )
  while( length( gls.fit.list[[ i ]] ) == 1 ) {
    start.lambda = start.lambda + 0.05
    gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfcltail , correlation = corPagel( start.lambda , cltailTREE.temp ) ) )						
  }
  names( gls.fit.list )[i] <- as.character( models[i] )
} 

gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] , lambda = "get" )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]

for( i in 1:length(gls.tables.list) ){
  gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
}

write.csv( do.call( rbind , gls.tables.list ) , file = "CoM_part2_cl_TailpGLS.csv" )

### OLS ###
right.sides <- c("1", "tailcvhvol")
  models <- paste( "tailskinvol ~" , right.sides ) 
    models <- lapply( models , as.formula )

gls.fit.list <- list()			
for( i in 1:length( models ) ) {
  gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfcltail ) )
  while( length( gls.fit.list[[ i ]] ) == 1 ) {
    gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfcltail ) )						
  }
  names( gls.fit.list )[i] <- as.character( models[i] )
} 

gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]

for( i in 1:length(gls.tables.list) ){
  gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
}

write.csv( do.call( rbind , gls.tables.list ) , file = "CoM_part2_cl_TailOLS.csv" )

### All models ####

### pGLS ###
right.sides <- c("1", "thighcvhvol * phylo")
  models <- paste( "thighskinvol ~" , right.sides ) 
    models <- lapply( models , as.formula )

gls.fit.list <- list()			
for( i in 1:length( models ) ) {
  start.lambda <- 0
  gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfallthigh , correlation = corPagel( start.lambda , allthighTREE.temp ) ) )
  while( length( gls.fit.list[[ i ]] ) == 1 ) {
    start.lambda = start.lambda + 0.05
    gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfallthigh , correlation = corPagel( start.lambda , allthighTREE.temp ) ) )						
  }
  names( gls.fit.list )[i] <- as.character( models[i] )
} 

gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] , lambda = "get" )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]

for( i in 1:length(gls.tables.list) ){
  gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
}

write.csv( do.call( rbind , gls.tables.list ) , file = "CoM_part2_all_Thigh_pAncova.csv" )

### OLS still cvh vols are right side, skin as other###
right.sides <- c("1", "neckcvhvol * phylo")
  models <- paste( "neckskinvol ~" , right.sides ) 
    models <- lapply( models , as.formula )

gls.fit.list <- list()			
for( i in 1:length( models ) ) {
  gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfall ) )
  while( length( gls.fit.list[[ i ]] ) == 1 ) {
    gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfall ) )						
  }
  names( gls.fit.list )[i] <- as.character( models[i] )
} 

gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]

for( i in 1:length(gls.tables.list) ){
  gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
}

write.csv( do.call( rbind , gls.tables.list ) , file = "CoM_part2_all_Neck_OLSpAncova.csv" )


