setwd("~/Karl_NewMasterDataFiles_March2021/Part1_May2021")

### Required packages ####
require(nlme)
require(ape)
require(qpcR)
require(ggplot2)
require(ggalt)
require(phytools)
require(geiger)

### Load the data ####
metadata <- read.csv("CoM_homo.csv")
metadatanorm <- read.csv("CoM_homonorm.csv")
metadatalinear <- read.csv("CoM_linear.csv")
metadatalinearnorm <- read.csv("CoM_linearnorm.csv")
trees <- read.nexus("output.nex") ### Reads Jetz tree distribution based on Hackett backbone
trees <- lapply(trees , ladderize, right = F) ### Ladderizes nodes in trees for plotting etc.
FLDtrees <- read.nexus("FLDtrees.nex") ### Reads Jetz tree distribution based on Hackett backbone
FLDtrees <- lapply(FLDtrees , ladderize, right = F) ### Ladderizes nodes in trees for plotting etc.
HLDtrees <- read.nexus("HLDtrees.nex") ### Reads Jetz tree distribution based on Hackett backbone
HLDtrees <- lapply(HLDtrees , ladderize, right = F) ### Ladderizes nodes in trees for plotting etc.
HLDnoratstrees <- read.nexus("HLDnoratstrees.nex") ### Reads Jetz tree distribution based on Hackett backbone
HLDnoratstrees <- lapply(HLDnoratstrees , ladderize, right = F) ### Ladderizes nodes in trees for plotting etc.
ALLnoratstrees <- read.nexus("ALLnoratstrees.nex") ### Reads Jetz tree distribution based on Hackett backbone
ALLnoratstrees <- lapply(ALLnoratstrees , ladderize, right = F) ### Ladderizes nodes in trees for plotting etc.

### Prepping the data for analysis ####

i = 1 ### Making sure the tree matches up with the species list in metadata ###
  TREE.temp <- trees[[ i ]]
    drop.taxa <- TREE.temp$tip.label[ is.na( match( TREE.temp $ tip.label , metadata $ BirdTree_names ) ) ]
      TREE.temp <- drop.tip( TREE.temp , drop.taxa )

      metadata <- metadata[ match( TREE.temp $ tip.label , metadata $ BirdTree_names ) , ]
        rownames( metadata ) <- metadata $ BirdTree_names
        
i = 1 ### Making sure the tree matches up with the species list in metadatanorm ###
  TREE.temp <- trees[[ i ]]
    drop.taxa <- TREE.temp$tip.label[ is.na( match( TREE.temp $ tip.label , metadatanorm $ BirdTree_names ) ) ]
      TREE.temp <- drop.tip( TREE.temp , drop.taxa )
        
      metadatanorm <- metadatanorm[ match( TREE.temp $ tip.label , metadatanorm $ BirdTree_names ) , ]
        rownames( metadatanorm ) <- metadatanorm $ BirdTree_names
        
i = 1 ### Making sure the tree matches up with the species list in metadatalinear ###
  TREE.temp <- trees[[ i ]]
    drop.taxa <- TREE.temp$tip.label[ is.na( match( TREE.temp $ tip.label , metadatalinear $ BirdTree_names ) ) ]
      TREE.temp <- drop.tip( TREE.temp , drop.taxa )
        
      metadatalinear <- metadatalinear[ match( TREE.temp $ tip.label , metadatalinear $ BirdTree_names ) , ]
        rownames( metadatalinear ) <- metadatalinear $ BirdTree_names
        
i = 1 ### Making sure the tree matches up with the species list in metadatalinearnorm ###
  TREE.temp <- trees[[ i ]]
    drop.taxa <- TREE.temp$tip.label[ is.na( match( TREE.temp $ tip.label , metadatalinearnorm $ BirdTree_names ) ) ]
      TREE.temp <- drop.tip( TREE.temp , drop.taxa )
        
      metadatalinearnorm <- metadatalinearnorm[ match( TREE.temp $ tip.label , metadatalinearnorm $ BirdTree_names ) , ]
        rownames( metadatalinearnorm ) <- metadatalinearnorm $ BirdTree_names
        
df <- data.frame (species =  metadata$BirdTree_names, ### Making a dataframe for metadata ###
                  locomotion = metadata$LocomotorMode,
                  flying = metadata$LocomotorMode == "Flying",
                  terrestrial = metadata$LocomotorMode == "Terrestrial",
                  ratite = metadata$Ratite,
                  body_mass = log10(metadata$Body_mass), 
                  model_mass = log10(metadata$Model_Mass),
                  rawDV = log10(metadata$rawDV), 
                  rawCC = log10(metadata$rawCC),
                  DVCOM = metadata$DVCoM.BM33,
                  CCCOM = metadata$CCCoM.BM33
                  )

dfnorm <- data.frame (species =  metadatanorm$BirdTree_names,### Making a dataframe for metadatanorm ###
                      locomotion = metadatanorm$LocomotorMode,
                      flying = metadatanorm$LocomotorMode == "Flying",
                      terrestrial = metadatanorm$LocomotorMode == "Terrestrial",
                      ratite = metadatanorm$Ratite,
                      body_mass = log10(metadatanorm$Body_mass), 
                      model_mass = log10(metadatanorm$Model_Mass),
                      DVCOM = metadatanorm$DVCoM.BM33,
                      CCCOM = metadatanorm$CCCoM.BM33,
                      head_mass = metadatanorm$Head_Mass,
                      neck_mass = metadatanorm$Neck_Mass,
                      torso_mass = metadatanorm$Torso_Mass,
                      humeral_mass = metadatanorm$Humeral_Mass,
                      forearm_mass = metadatanorm$Forearm_Mass,
                      hand_mass = metadatanorm$Hand_Mass,
                      thigh_mass = metadatanorm$Thigh_Mass,
                      shank_mass = metadatanorm$Shank_Mass,
                      mt_mass = metadatanorm$MT_Mass,
                      pes_mass = metadatanorm$Pes_Mass,
                      hindlimb_mass = metadatanorm$Hindlimb_Mass,
                      forelimb_mass = metadatanorm$Forelimb_Mass,
                      dvheadfmm = metadatanorm$DVHead_FMM,
                      dvneckfmm = metadatanorm$DVNeck_FMM,
                      dvtorsofmm = metadatanorm$DVTorso_FMM,
                      dvhumeralfmm = metadatanorm$DVHumeral_FMM,
                      dvforearmfmm = metadatanorm$DVForearm_FMM,
                      dvhandfmm = metadatanorm$DVHand_FMM,
                      dvthighfmm = metadatanorm$DVThigh_FMM,
                      dvshankfmm = metadatanorm$DVShank_FMM,
                      dvmtfmm = metadatanorm$DvMT_FMM,
                      dvfootfmm = metadatanorm$DVFoot_FMM,
                      dvhindlimbfmm = metadatanorm$DVHindlimb_FMM,
                      dvforelimbfmm = metadatanorm$DVForelimb_FMM,
                      ccheadfmm = metadatanorm$CCHead_FMM,
                      ccneckfmm = metadatanorm$CCNeck_FMM,
                      cctorsofmm = metadatanorm$CCTorso_FMM,
                      cchumeralfmm = metadatanorm$CCHumeral_FMM,
                      ccforearmfmm = metadatanorm$CCForearm_FMM,
                      cchandfmm = metadatanorm$CCHand_FMM,
                      ccthighfmm = metadatanorm$CCThigh_FMM,
                      ccshankfmm = metadatanorm$CCThigh_FMM,
                      ccmtfmm = metadatanorm$CCMT_FMM,
                      ccfootfmm = metadatanorm$CCFoot_FMM,
                      cchindlimbfmm = metadatanorm$CCHindlimb_FMM,
                      ccforelimbfmm = metadatanorm$CCForelimb_FMM,
                      dvcomhead = metadatanorm$DVCoM_Head,
                      dvcomneck = metadatanorm$DVCoM_Neck,
                      dvcomtorso = metadatanorm$DVCoM_Torso,
                      dvcomhumeral = metadatanorm$DVCoM_Humeral,
                      dvcomforearm = metadatanorm$DVCoM_Forearm,
                      dvcomhand = metadatanorm$DVCoM_Hand,
                      dvcomthigh = metadatanorm$DVCoM_Thigh,
                      dvcomshank = metadatanorm$DVCoM_Shank,
                      dvcommt = metadatanorm$DVCoM_MT,
                      dvcomfoot = metadatanorm$DVCoM_Foot,
                      dvcomhindlimb = metadatanorm$DVCoM_Hindlimb,
                      dvcomforelimb = metadatanorm$DVCoM_Forelimb,
                      cccomhead = metadatanorm$CCCoM_Head,
                      cccomneck = metadatanorm$CCCoM_Neck,
                      cccomtorso = metadatanorm$CCCoM_Torso,
                      cccomhumeral = metadatanorm$CCCoM_Humeral,
                      cccomforearm = metadatanorm$CCCoM_Forearm,
                      cccomhand = metadatanorm$CCCoM_Hand,
                      cccomthigh = metadatanorm$CCCoM_Thigh,
                      cccomshank = metadatanorm$CCCoM_Shank,
                      cccommt = metadatanorm$CCCoM_MT,
                      cccomfoot = metadatanorm$CCCoM_Foot,
                      cccomhindlimb = metadatanorm$CCCoM_Hindlimb,
                      cccomforelimb = metadatanorm$CCCoM_Forelimb
                      )

dflinear <- data.frame(species = metadatalinear$BirdTree_names, ### Making a dataframe for metadatalinear ###
                       locomotion = metadatalinear$LocomotorMode,
                       body_mass = log10(metadatalinear$Body_mass),
                       DVCOM = metadatalinear$DVCoM.BM33,
                       CCCOM = metadatalinear$CCCoM.BM33,
                       pelvic_width = metadatalinear$PelvicWidth,
                       pelvic_length = metadatalinear$PelvicLength,
                       thigh_length = metadatalinear$ThighLength,
                       shank_length = metadatalinear$ShankLength,
                       mt_length = metadatalinear$MTLength,
                       foot_length = metadatalinear$FootLength,
                       shoulder_width = metadatalinear$ShoulderWidth,
                       humeral_length = metadatalinear$HumeralLength,
                       forearm_length = metadatalinear$ForearmLength,
                       hand_length = metadatalinear$HandLength,
                       neck_length = metadatalinear$NeckLength,
                       skull_length = metadatalinear$SkullLength,
                       sternum_length = metadatalinear$SternumLength,
                       sternum_depth1 = metadatalinear$SternumDepth1,
                       sternum_depth2 = metadatalinear$SternumDepth2,
                       hindlimb_length = metadatalinear$HindlimbLength,
                       forelimb_length = metadatalinear$ForelimbLength,
                       ga_length = metadatalinear$GALength
                       )

dflinearnorm <- data.frame(species = metadatalinearnorm$BirdTree_names, ### Making a dataframe for metadatalinearnorm ###
                       locomotion = metadatalinearnorm$LocomotorMode,
                       ratite = metadatalinearnorm$Ratite,
                       body_mass = log10(metadatalinearnorm$Body_mass),
                       DVCOM = metadatalinearnorm$DVCoM.BM33,
                       CCCOM = metadatalinearnorm$CCCoM.BM33,
                       pelvic_width = metadatalinearnorm$PelvicWidth,
                       pelvic_length = metadatalinearnorm$PelvicLength,
                       thigh_length = metadatalinearnorm$ThighLength,
                       shank_length = metadatalinearnorm$ShankLength,
                       mt_length = metadatalinearnorm$MTLength,
                       foot_length = metadatalinearnorm$FootLength,
                       shoulder_width = metadatalinearnorm$ShoulderWidth,
                       humeral_length = metadatalinearnorm$HumeralLength,
                       forearm_length = metadatalinearnorm$ForearmLength,
                       hand_length = metadatalinearnorm$HandLength,
                       neck_length = metadatalinearnorm$NeckLength,
                       skull_length = metadatalinearnorm$SkullLength,
                       sternum_length = metadatalinearnorm$SternumLength,
                       sternum_depth1 = metadatalinearnorm$SternumDepth1,
                       sternum_depth2 = metadatalinearnorm$SternumDepth2,
                       hindlimb_length = metadatalinearnorm$HindlimbLength,
                       forelimb_length = metadatalinearnorm$ForelimbLength,
                       ga_length = metadatalinearnorm$GALength
                       )

### Creating the glsTable function ####

#Function to make pgls results table from set of gls results. Requires input of both the model of interest and the null model for comparison. Computes R2 using Nagelkerke's genearlised R2.
#Roger Benson 16 January 2020

require( nlme )
library( qpcR )

glsTable <- function( fit , null , roundC = 3 , roundP = 4 , lambda = c( 0 , 1 , "get" )[ 1 ] ) {
  
  coef <- cbind( round( summary(fit)$tTable[ , c(1,2,3) ] , roundC ) , round( summary(fit)$tTable[ , c(4) ] , roundP ) )
  colnames( coef )[ 4 ] <- "p value"
  
  model <- summary(fit)$call[[ 2 ]]
  model <- paste( model )
  model <- model[ -1 ]
  model <- paste( model[ 1 ] , "~" , model[ 2 ] )
  
  N <- fit$dims$N
  R2 <- round( 1-exp(-1*2/ N * ( fit $ logLik - null $ logLik ) ) , roundC )
  aicc <- round( AICc( fit ) , roundC )
  
  line.temp <- c( model , N , aicc , R2 )
  if( lambda == "get" ){ line.temp <- c( line.temp , round( fit$modelStruct[[1]][1] , roundC ) )
  }	else	{ line.temp <- c( line.temp , lambda ) }
  
  
  model.out <- matrix( ncol = length( line.temp ) , nrow = nrow( coef ) )
  model.out[ 1 , ] <- line.temp
  colnames( model.out ) <- c( "model" , "N" , "AICc" , "R2" , "lambda" )
  out <- cbind( model.out , coef )
  
  out
}

### Q1 - Plotting CCCOM vs DVCOM ####

ggplot(df, aes(x=CCCOM, y=DVCOM), colour=locomotion) + 
  geom_point(aes(colour=locomotion), size = 5) + 
  geom_encircle(aes(fill=locomotion), s_shape = 1, expand =0, alpha = 0.2, color="black", show.legend = FALSE) + 
  scale_x_continuous(name = expression("Cranio-caudal CoM position (Distance in front of hip/body mass)"^0.33)) + 
  scale_y_continuous(name = expression("Dorso-ventral CoM position (Distance below hip/body mass)"^0.33)) + 
  theme_bw() + 
  theme(text = element_text(size = 20)) + 
  labs(colour="Locomotion")

### Q1 - Do extant HLD birds differ from FLD birds in CoM position? ####

right.sides <- c("1","locomotion" )
  models <- paste( "CCCOM ~" , right.sides ) ### Enter CC or DV on left side of equation here ###
    models <- lapply( models , as.formula )

    gls.fit.list <- list()			
    for( i in 1:length( models ) ) {
      start.lambda <- 0
      gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = df , correlation = corPagel( start.lambda , TREE.temp ) ) )
      while( length( gls.fit.list[[ i ]] ) == 1 ) {
        start.lambda = start.lambda + 0.05
        gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = df , correlation = corPagel( start.lambda , TREE.temp ) ) )						
      }
      names( gls.fit.list )[i] <- as.character( models[i] )
    } 

gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] , lambda = "get" )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]

for( i in 1:length(gls.tables.list) ){
  gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
}

write.csv( do.call( rbind , gls.tables.list ) , file = "Q1_COM_CCCOM_Brownian.csv" )

### Q2 - How does CoM position scale in extant birds? ####

### Prelim - subsetting data based on HLD/FLD and 'no ratites' ###

FLD <- subset(df, locomotion == "Flying")
i = 1 ### Making sure the tree matches up with the species list in FLD ###
FLDTREE.temp <- FLDtrees[[ i ]]
  FLDdrop.taxa <- FLDTREE.temp$tip.label[ is.na( match( FLDTREE.temp $ tip.label , FLD $ species ) ) ]
    FLDTREE.temp <- drop.tip( FLDTREE.temp , FLDdrop.taxa )

    FLD <- FLD[ match( FLDTREE.temp $ tip.label , FLD $ species ) , ]
      rownames( FLD ) <- FLD $ species

HLD <- subset(df, locomotion == "Terrestrial")
i = 1 ### Making sure the tree matches up with the species list in HLD ###
HLDTREE.temp <- HLDtrees[[ i ]]
  HLDdrop.taxa <- HLDTREE.temp$tip.label[ is.na( match( HLDTREE.temp $ tip.label , HLD $ species ) ) ]
    HLDTREE.temp <- drop.tip( HLDTREE.temp , HLDdrop.taxa )

    HLD <- HLD[ match( HLDTREE.temp $ tip.label , HLD $ species ) , ]
      rownames( HLD ) <- HLD $ species
      
ALLnorats <- subset(df, ratite == "FALSE")
i = 1 ### Making sure the tree matches up with the species list in HLD ###
ALLnoratsTREE.temp <- ALLnoratstrees[[ i ]]
  ALLnoratsdrop.taxa <- ALLnoratsTREE.temp$tip.label[ is.na( match( ALLnoratsTREE.temp $ tip.label , ALLnorats $ species ) ) ]
    ALLnoratsTREE.temp <- drop.tip( ALLnoratsTREE.temp , ALLnoratsdrop.taxa )

    ALLnorats <- ALLnorats[ match( ALLnoratsTREE.temp $ tip.label , ALLnorats $ species ) , ]
      rownames( ALLnorats ) <- ALLnorats $ species

HLDnorats <- HLD[5:13,]
i = 1 ### Making sure the tree matches up with the species list in HLD ###
HLDnoratsTREE.temp <- HLDnoratstrees[[ i ]]
  HLDnoratsdrop.taxa <- HLDnoratsTREE.temp$tip.label[ is.na( match( HLDnoratsTREE.temp $ tip.label , HLDnorats $ species ) ) ]
    HLDnoratsTREE.temp <- drop.tip( HLDnoratsTREE.temp , HLDnoratsdrop.taxa )

    HLDnorats <- HLDnorats[ match( HLDnoratsTREE.temp $ tip.label , HLDnorats $ species ) , ]
      rownames( HLDnorats ) <- HLDnorats $ species
      
### Body mass variation between FLD and HLD birds ###

BMvar_ALL <- gls(data = df, body_mass ~ locomotion, correlation = corPagel(1, phy = TREE.temp))
  summary(BMvar_ALL)

BMvar_norats <- gls(data = ALLnorats, body_mass ~ locomotion, correlation = corPagel(1, phy = ALLnoratsTREE.temp))
  summary(BMvar_norats)

### Scaling of CoM with body mass ###

right.sides <- c("1", "body_mass", "model_mass" )
  models <- paste( "rawDV ~" , right.sides ) ### Enter CC or DV on left side of equation here ###
    models <- lapply( models , as.formula )
      
    
    gls.fit.list <- list()			
    for( i in 1:length( models ) ) {
      gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = HLD , correlation = corPagel(1, phy = HLDTREE.temp ) ) )
      while( length( gls.fit.list[[ i ]] ) == 1 ) {
        gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = HLD , correlation = corPagel(1, phy = HLDTREE.temp ) ) )						
      }
      names( gls.fit.list )[i] <- as.character( models[i] )
    }
    
      
      gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] , lambda = "get" )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]
      
      for( i in 1:length(gls.tables.list) ){
        gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
      }
      
      write.csv( do.call( rbind , gls.tables.list ) , file = "Q2_COM_rawDV.csv" )
      
### Comparing slopes using phylogenetic ANCOVA ###

      q2rawCC <- gls(rawCC ~ body_mass * locomotion, data = df, correlation = corPagel(1, phy = TREE.temp))
        summary(q2rawCC)
             
      q2rawDV <- gls(rawDV ~ body_mass * locomotion, data = df, correlation = corPagel(1, phy = TREE.temp))
        summary(q2rawDV)
            
      q2noratsrawCC <- gls(rawCC ~ body_mass * locomotion, data = ALLnorats, correlation = corPagel(1, phy = ALLnoratsTREE.temp))
       summary(q2noratsrawCC)
            
      q2noratsrawDV <- gls(rawDV ~ body_mass * locomotion, data = ALLnorats, correlation = corPagel(1, phy = ALLnoratsTREE.temp))
        summary(q2noratsrawDV)
           
### Q3- Which body segments underpin the trends in CoM positon in Q1 and Q2? ####

### CoM vs linear segment measurements ###
        
right.sides <- c("1", "pelvic_width", "pelvic_length", "thigh_length", "shank_length", "mt_length", "foot_length", "shoulder_width", "humeral_length", "forearm_length", "hand_length", "neck_length", "skull_length", "sternum_length", "sternum_depth1", "sternum_depth2", "hindlimb_length", "forelimb_length", "ga_length")
  models <- paste( "CCCOM ~" , right.sides ) ### Enter CC or DV on left side of equation here ###
    models <- lapply( models , as.formula )
    
### coM vs segment mass, CoM and FMM ###

right.sides <- c("1", "head_mass", "neck_mass", "torso_mass", "humeral_mass", "forearm_mass", "hand_mass", "thigh_mass", "shank_mass", "mt_mass", "pes_mass", "hindlimb_mass", "forelimb_mass", "dvheadfmm", "dvneckfmm", "dvtorsofmm", "dvhumeralfmm", "dvforearmfmm", "dvhandfmm", "dvthighfmm", "dvshankfmm", "dvmtfmm", "dvfootfmm", "dvhindlimbfmm", "dvforelimbfmm", "ccheadfmm", "ccneckfmm", "cctorsofmm", "cchumeralfmm", "ccforearmfmm", "cchandfmm", "ccthighfmm", "ccshankfmm", "ccmtfmm", "cchindlimbfmm", "ccforelimbfmm", "cccomhead", "cccomneck", "cccomtorso", "cccomhumeral", "cccomforearm", "cccomhand", "cccomthigh", "cccomshank", "cccommt", "cccomhindlimb", "cccomforelimb", "dvcomhead", "dvcomneck", "dvcomtorso", "dvcomhumeral", "dvcomforearm", "dvcomhand", "dvcomthigh", "dvcomshank", "dvcommt", "dvcomhindlimb", "dvcomforelimb")
  models <- paste( "DVCOM ~" , right.sides ) ### Enter CC or DV on left side of equation here ###
    models <- lapply( models , as.formula )

gls.fit.list <- list()			
  for( i in 1:length( models ) ) {
    start.lambda <- 0
      gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfnorm , correlation = corPagel( start.lambda , TREE.temp ) ) )
      while( length( gls.fit.list[[ i ]] ) == 1 ) {
        start.lambda = start.lambda + 0.05
          gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfnorm , correlation = corPagel( start.lambda , TREE.temp ) ) )						
      }
      names( gls.fit.list )[i] <- as.character( models[i] )
    } 
        
gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] , lambda = "get" )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]
     
for( i in 1:length(gls.tables.list) ){
  gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
  }
        
write.csv( do.call( rbind , gls.tables.list ) , file = "Q3_COM_DVCOM_mass.csv" )

### Q4 - Differences in body segment proportions between FLD and HLD birds? ####

### Prep - remove ratites from dflinearnorm and dfnorm ###

linearnorats <- subset(dflinearnorm, ratite == "FALSE")
i = 1 ### Making sure the tree matches up with the species list in HLD ###
  linearnoratsTREE.temp <- ALLnoratstrees[[ i ]]
    ALLnoratsdrop.taxa <- ALLnoratsTREE.temp$tip.label[ is.na( match( ALLnoratsTREE.temp $ tip.label , ALLnorats $ species ) ) ]
      ALLnoratsTREE.temp <- drop.tip( ALLnoratsTREE.temp , ALLnoratsdrop.taxa )

      ALLnorats <- ALLnorats[ match( ALLnoratsTREE.temp $ tip.label , ALLnorats $ species ) , ]
        rownames( ALLnorats ) <- ALLnorats $ species
        
massnorats <- subset(dfnorm, ratite == "FALSE")
i = 1 ### Making sure the tree matches up with the species list in HLD ###
  massnoratsTREE.temp <- ALLnoratstrees[[ i ]]
      ALLnoratsdrop.taxa <- ALLnoratsTREE.temp$tip.label[ is.na( match( ALLnoratsTREE.temp $ tip.label , ALLnorats $ species ) ) ]
        ALLnoratsTREE.temp <- drop.tip( ALLnoratsTREE.temp , ALLnoratsdrop.taxa )
        
        ALLnorats <- ALLnorats[ match( ALLnoratsTREE.temp $ tip.label , ALLnorats $ species ) , ]
          rownames( ALLnorats ) <- ALLnorats $ species

### Linear segment measurements vs locomotion ###

left.sides <- c("pelvic_width ~","pelvic_width ~", "pelvic_length ~", "thigh_length ~", "shank_length ~", "mt_length ~", "foot_length ~", "shoulder_width ~", "humeral_length ~", "forearm_length ~", "hand_length ~", "neck_length ~", "skull_length ~", "sternum_length ~", "sternum_depth1~", "sternum_depth2 ~", "hindlimb_length ~", "forelimb_length ~", "ga_length ~")
  models <- paste(left.sides, "locomotion") 
    models <- lapply( models , as.formula )

    
gls.fit.list <- list()			
  for( i in 1:length( models ) ) {
    start.lambda <- 0
      gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dflinearnorm , correlation = corPagel( start.lambda , TREE.temp ) ) ) ### change to linearnorats when removing ratites ###
      while( length( gls.fit.list[[ i ]] ) == 1 ) {
        start.lambda = start.lambda + 0.05
         gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dflinearnorm , correlation = corPagel( start.lambda , TREE.temp ) ) ) ### change to linearnorats when removing ratites ###						
      }
      names( gls.fit.list )[i] <- as.character( models[i] )
  } 

gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] , lambda = "get" )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]

for( i in 1:length(gls.tables.list) ){
  gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
}

write.csv( do.call( rbind , gls.tables.list ) , file = "Q4_linear_ALLTaxa.csv" )

### Mass/FMM/CoM segment measurements vs locomotion ###

left.sides <- c("head_mass ~","head_mass ~", "neck_mass ~", "torso_mass ~", "humeral_mass ~", "forearm_mass ~", "hand_mass ~", "thigh_mass ~", "shank_mass ~", "mt_mass ~", "pes_mass ~", "hindlimb_mass ~", "forelimb_mass ~", "dvheadfmm ~", "dvneckfmm ~", "dvtorsofmm ~", "dvhumeralfmm ~", "dvforearmfmm ~", "dvhandfmm~", "dvthighfmm ~", "dvshankfmm ~", "dvmtfmm ~", "dvfootfmm ~", "dvhindlimbfmm ~", "dvforelimbfmm ~", "ccheadfmm ~", "ccneckfmm ~", "cctorsofmm ~", "cchumeralfmm ~", "ccforearmfmm ~", "cchandfmm ~", "ccthighfmm ~", "ccshankfmm ~", "ccmtfmm ~", "cchindlimbfmm ~", "ccforelimbfmm ~", "cccomhead ~", "cccomneck ~", "cccomtorso ~", "cccomhumeral ~", "cccomforearm ~", "cccomhand ~", "cccomthigh ~", "cccomshank ~", "cccommt ~", "cccomhindlimb ~", "cccomforelimb ~", "dvcomhead ~", "dvcomneck ~", "dvcomtorso ~", "dvcomhumeral ~", "dvcomforearm ~", "dvcomhand ~", "dvcomthigh ~", "dvcomshank ~", "dvcommt ~", "dvcomhindlimb ~", "dvcomforelimb ~")
  models <- paste(left.sides, "locomotion") 
    models <- lapply( models , as.formula )


gls.fit.list <- list()			
for( i in 1:length( models ) ) {
  start.lambda <- 0
    gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfnorm , correlation = corPagel( start.lambda , TREE.temp ) ) ) ### change to massnorats when removing ratites ###
    while( length( gls.fit.list[[ i ]] ) == 1 ) {
      start.lambda = start.lambda + 0.05
        gls.fit.list[[ i ]] <- try( gls( models[[ i ]] , data = dfnorm , correlation = corPagel( start.lambda , TREE.temp ) ) ) ### change to massnorats when removing ratites ###						
    }
    names( gls.fit.list )[i] <- as.character( models[i] )
} 

gls.tables.list <- lapply( gls.fit.list[-1] , glsTable , null = gls.fit.list[[ 1 ]] , lambda = "get" )[ order( unlist( lapply( gls.fit.list[-1] , AICc ) ) ) ]

for( i in 1:length(gls.tables.list) ){
  gls.tables.list[[i]][1,1] <- names( gls.tables.list )[i]
}

write.csv( do.call( rbind , gls.tables.list ) , file = "Q4_mass_ALLTaxa.csv" )
      