#!/usr/bin/python
# -*- coding: utf-8 -*-

#     Doug S. Szumski  <d.s.szumski@gmail.com>  14-06-2012
#     with contributions from Richard Brooke
#
#     Processing and analysis script for quad channel STM module
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#Updates are posted at: https://github.com/dougszumski/Scanmaster-3000
#Git repo: git://github.com/dougszumski/Scanmaster-3000.git
#For push access contact Doug

#Multithreading support
import threading
from Queue import Queue
# Dialogue
from Tkinter import *
from tkFileDialog import askopenfilename, asksaveasfile
from tkColorChooser import askcolor
from tkMessageBox import askquestion, showerror, showinfo
from tkSimpleDialog import askfloat
from tkMessageBox import askokcancel
from FileDialog import LoadFileDialog
from Dialog import Dialog
import signal
# File IO
import shutil  # High level file from scipy import stats
import os  # import command line for file operations
from subprocess import call
import string
import cPickle
import gzip
#Debugging
import random
import time

import numpy as np


scan_u_th = 3
scan_l_th = 0.009
chunksize = 100000
max_seg_len = 3000
min_seg_len = 1800


def groupavg(data):
    # Returns the average value of a string of data points
    tmp = 0.00
    for value in data:
        tmp += value
    tmp /= len(data)
    return tmp

def fileoutput(
    filename,
    data_1,
    data_2,
    data_3,
    data_4,
    ):
    """Writes quad channel data to file."""
    
    points = len(data_1)
    with open(filename, 'w') as FILE:
        for i in range(0, points):
            FILE.write('%s' % data_1[i] + '\t %s' % data_2[i] + '\t %s'
                       % data_3[i] + '\t %s \n' % data_4[i])

def chopper(data_1, data_2, data_3, data_4, l_th, u_th, filecounter, output_dir):
    """Chops the continuous data file into individual scans."""
   
    data_window = []
    # The number of points to not include from the determined 'end' (prevents problems with other channels)
    int_bodge = 20
    window_length = 50
    l_plat_len = 0
    u_plat_len = 0
    counter = 0
    start = 0
    stop = 0
    
    # Only data above u_th should be discarded as data below l_th is required for the background correction
    # Detect it the tip substrate bias is positive or negative to allow auto-inversion of data
    # The average of the LSx1 channel is a good, but inefficient measure of this
    # TODO: If the warning appears frequently parameterise this in the GUI with a manual override

    dat_avg = np.average(data_1)
    print "LSx1 channel average is: ", dat_avg, "V"
    if (dat_avg < -0.5):
        print "Assuming negative tip-substrate bias"
        #Invert the data
        #FIXME get rid of the now redundant inversion check when reading the split files back in
        for i in range(len(data_1)):
                data_1[i] = data_1[i] * -1.0
                data_2[i] = data_2[i] * -1.0
                data_3[i] = data_3[i] * -1.0
                data_4[i] = data_4[i] * -1.0
    elif (dat_avg > 0.5):
        print "Assuming positive tip-substrate bias"
    

    # filecounter = 0
    # Implement minimum

    for value in data_1:
        data_window.append(value)
        if len(data_window) > window_length:
            # Get rid off the first value to make way for the last
            del data_window[0]
        if len(data_window) == window_length:
            # Full window so do some checks for lower threshold
            if groupavg(data_window) < l_th:
                # Found a plateau so increment the length counter
                l_plat_len += 1
            if groupavg(data_window) > u_th:
                # Found a plateau so increment the length counter
                u_plat_len += 1
            if groupavg(data_window) < u_th and u_plat_len > 0 and stop \
                == 0:
                # Hopefully this is the tip retraction point and from here on the current decays
                # Stop must be zero otherwise we might end up with background, then decay!
                start = counter  # could make this "counter - u_plat_len" to get all the plateaus but not of interest
                # print "Found upper plateau: ", u_plat_len, " points long, stopping at: ", start
                u_plat_len = 0
            if groupavg(data_window) > l_th and l_plat_len > 0 \
                and start != 0:
                # We found the end of the background plateau at the previous counter value
                # start must be > 0 to ensure we have already found the initial current decay
                stop = counter - int_bodge
                # start is at the location of the last found upper plateau
                # print "Found lower plateau: ", l_plat_len, " point long, stopping at: ", stop........
                points = stop - start
                # A bit of a 'hatchet job', basically check CH2 remains saturated for x number of points,
                # akin to checking the gradient of CH1
                # TODO: Bug here: this assumes the channnel is saturated which is only the case for BJ experiments
                sat_level = data_2[start]
                sat_pass = True
                if len(data_2) >= (start+50): #Get rid of obscure error which happened in T54
                    for i in range(0, 50):
                        if sat_level != data_2[start + i]:
                            sat_pass = False
                            print "REJECTED: No stable set-point current detected"

                        # print sat_level, data_2[i]
                # Dislocations due to moving the scanner during a I(s) measurements need to be removed.
                # For example:
                # 4.01572.... 10.3392.... 10.454.... 10.3357
                # 0.0261655.... 0.252062.... 6.06029.... 10.3357
                # But for now we don't worry about that here and deal with it later in the stitcher
                # Now check to see if the high sens channel has reached zero, otherwise it's a #*$% end point / measurement

                lowchan_pass = True
                background_level = groupavg(data_3[stop - 10:stop])
                if background_level > l_th:
                    lowchan_pass = False
                    # The level will depend on the 'characteristic level' of the experiment.
                    # For bare contacts this should of the order of mV. For in-situ work it will depend on the tip leakage current. 
                    print 'REJECTED: HS x10 voltage decayed to:', background_level, '(V). Threshold level:', l_th, '(V)'
   
                # Save the measurements if they pass some tests:
                # Each scan should have a characteristic length. If you wanted to be flash you could plot a histogram of
                # Scan length. Then choose only scans within a couple of SDs of the mean length.
                # In this case the length is controlled manually and will depend on the scan duration in seconds.
                # If the scan duration is changed adjust the acceptable range to the characteristic length
                # This acts as a filter to prevent multiple length scans, or unreasonably short I(s) scans getting through

                if points > min_seg_len and points < max_seg_len and sat_pass \
                    and lowchan_pass:
                    data_slice1 = data_1[start:stop]
                    data_slice2 = data_2[start:stop]  # Matching one from x10 channel
                    data_slice3 = data_3[start:stop]
                    data_slice4 = data_4[start:stop]

                    # Generate the filename
                    # Later on this can calculate a sdev and dynamically exclude

                    filename = os.getcwd()[:-3] + output_dir + "/" + 'slice' + str(filecounter).zfill(4) \
                        + '.txt'
                    print 'Reconstructed I(s) scan containing: ', points, \
                        'data points as: ', filename
                    fileoutput(
                        filename,
                        data_slice1,
                        data_slice2,
                        data_slice3,
                        data_slice4,
                        )
                    filecounter += 1
                l_plat_len = 0
                start = 0
                stop = 0
        counter += 1
    return filecounter


def tea_break_maker():

    """Deals with reading all raw data files from the ADC and splitting them into I(s) scans using chopper"""
    # Attempt to prevent laziness by asking some questions about the experiment before processing the data
    # After these have been answered they'll be plenty of time for a tea break.

    questions = [
        "Experiment name                 :",
        "Sweep time (seconds)            :",
        "Sweep range (nm)                :",
        "Substrate material              :",
        "Tip material                    :",
        "Molecule                        :",
        "Environment                     :",
        "Magnetic field?                 :",
        "Preamp L sense (kOhm)           :",
        "Preamp H sense (MOhm)           :",
        "Other comments                  :",
        ]

    # Have a poke around in the raw directory so we can ask for comments on each file within
    files = os.listdir(os.path.abspath('raw'))
    for filename in files:
        # For each precious measurement we must have a description
        questions.append(filename
                         + " details (bias/setpoint/other)	:")

    #Generate some dialogue to guide/warn the user
    if (len(files) < 1):
        error = showerror('Disaster', 'No data found in ../raw')
        return
    info = showinfo('Scan reconstructor', 'Refer to the terminal')
    answers = []
   
    # Now ask the questions
    if not os.access('nfo.txt', os.F_OK):
        for question in questions:
            var = raw_input(question)
            answers.append(var)
        # Write the questions and answer to file for later viewing,
        # but if the file exists then don't overwrite it
        with open('nfo.txt', 'w') as FILE:
            for i in range(0, len(answers)):
                info = questions[i] + '\t' + answers[i] + '\n'
                FILE.write(info)
    else:
        print "Skipping questions: nfo.txt already exists"

    # Now for the chopping
    # Assumes you've put the raw data in ../raw/
    # Go into the raw data directory
    original_directory = os.getcwd()
    try:
        os.chdir(os.path.abspath('raw'))
        files = os.listdir(os.getcwd())
        #Start reconstruction of scans
        print 'This is a good time to have tea break...'
        process_files(files)
    finally:
        print 'Finished reconstructing I(s) scans'
        os.chdir(original_directory)

def process_files(files):
    def producer(q, files):
        for filename in files:
            thread = InitChopper(filename)
            thread.start()
            print "------------->   THREAD NAME ----------->", thread.getName()
            #Put the thread in the queue, arg True blocks if necessary until a slot is available 
            #FIXME: Waits for thread to finish -- not parallel. Rewrite chopper in C?
            thread.join()
            q.put(thread, True)

    def consumer(q, total_files):
        counter = 0
        while counter < total_files:
            #Remove and return an item from the queue, arg True blocks if necessary until item available
            thread = q.get(True)
            #Wait for thread to terminate
            thread.join()
            counter +=1

    q = Queue(3)
    prod_thread = threading.Thread(target=producer, args=(q, files))
    cons_thread = threading.Thread(target=consumer, args=(q, len(files)))
    prod_thread.start()
    cons_thread.start()
    #Wait for producer to terminate
    prod_thread.join() 
    cons_thread.join()

class InitChopper(threading.Thread):
    def __init__(self, filename):
        self.raw_data_filename = filename
        threading.Thread.__init__(self)

    def run(self):
        #NEED TO USE absolute paths, none of this CHDIR business
        # Reset the file counter for the chopped scans
        filecounter = 0
        data = True
        #Open the raw data file which should be gzipped 
        with gzip.open(self.raw_data_filename) as gz_data:
            # Create an output folder for the individual scans
            dirname = self.raw_data_filename[0:-7]
            output = 'chopped' + dirname[6:]
            print 'Reconstructing I(s) scans into the directory', output, '...'
            # Go out of the raw data folder........
            raw_directory = os.getcwd()
            try:
                #TODO MAKE THREAD SAFE -- PUT A LOCK HERE
                os.chdir(os.pardir)
                # Make the output folder for the I(s) scans if it doesn't exist already and cd into it
                if os.path.exists(output) != True:
                    os.mkdir(output)
                os.chdir(raw_directory)

                #os.chdir(os.path.abspath(output))
                # Reconstruct the I(s) scans only if the the folder is empty       
                #if os.listdir(os.getcwd()):
                #    print "Skipping scan reconstruction: target folder:", "../" + output, "is not empty"
                #    return
                #TODO REMOVE LOCK  -- change below path to abs 
                while data == True:
                    #Create empty current lists
                    i_list_ls_x1 = []
                    i_list_ls_x10 = []
                    i_list_hs_x1 = []
                    i_list_hs_x10 = []
                    for i in range(chunksize):
                        line = gz_data.readline()
                        if not line:
                            print "End of raw data: last chunk is", i," lines long."
                            #Don't do any more while loops
                            data = False
                            #Leave the for loop with i lines of data        
                            break
                        line = line.split()
                        #Populate the current lists
                        i_list_ls_x1.append(float(line[0]))
                        i_list_ls_x10.append(float(line[1]))
                        i_list_hs_x1.append(float(line[2])) 
                        i_list_hs_x10.append(float(line[3]))
                    #Now reconstruct the scans, but only if there is at least one line of data in the chunk
                    if line:
                        filecounter = chopper(
                            i_list_ls_x1,
                            i_list_ls_x10,
                            i_list_hs_x1,
                            i_list_hs_x10,
                            scan_l_th,
                            scan_u_th,
                            filecounter,
                            output
                            )
            finally:
                os.chdir(raw_directory)


tea_break_maker()

   
