%reduce the bin size for an mmd of a branched chain 
%
%SYNTAX
%OUT1=reducebinsize(IN1, IN2)
%   IN1 = initial MMD as a table:
%      row name = topology descriptor (see Table S13)
%      variable named mass = nxm matrix of DPs for each individual segment of each chain of given topology
%      variable named frac =  fraction of each chain in the ensemble
%   IN2 = the reducing factor as a common fraction [denominator, numerator], e.g.,  
%       IN2 = [2 1] will half the bin size
%       IN2 = [3, 2] will reduce the bin size by 1.5 
%
%   OUT1 = new MMD 
%   
%The increment in both original and reduced-bin MMDs is 1, but its "weight" is smaller in the reduced-bin MMD
% To make the code portable, we removed system memory checks, which may make the code terminate with the "Out of memory" error. The simplest
% work around is to rerun code on a system with more memory; see the "Code for generating product distributions" of the SI for other strategies to
% reduce memory requirement. All results in the examples.mat file were generated on a PC with 32 Gb of RAM.

function mmd=reducebinsize(mmd, mult)
warning('off'), 
dist=single(mmd.mass{1}*mult(1)); frac=single(mmd.frac{1});
mult=double([mult(1), max(dist, [], 'all'), mult(2)]);
for j=size(dist,2):-1:1
    if j<size(dist,2), [dist, tind]=sortrows(dist,[1:j-1, j+1:size(dist,2), j]); frac=frac(tind);  end
    ind=[[0; ismember(dist(1:end-1,:), [dist(2:end,1:j-1), dist(2:end,j)-mult(1), dist(2:end,j+1:end)], 'rows')],...
        [ismember(dist(2:end,:), [dist(1:end-1,1:j-1), dist(1:end-1,j)+mult(1), dist(1:end-1,j+1:end)], 'rows'); 0]]; 
    tind=[find(ismember(ind, [0 1], 'rows')), find(ismember(ind, [1 0], 'rows'))]; 
    ind=any(ind,2);
    ndist={}; ndist(:,[1,3])=mat2cell([dist(ind, j), frac(ind)], diff(tind, [], 2)+1, [1 1]);
        ndist(:, 2)=cellfun(@transpose, cellfun(@colon, num2cell(floor(single(cellfun(@min, ndist(:,1)))/mult(3))*mult(3)), repmat({mult(3)}, size(ndist,1),1),...
        num2cell(ceil(single(cellfun(@max, ndist(:, 1)))/mult(3))*mult(3)),'UniformOutput', 0),'UniformOutput', 0);
       ind1=cellfun(@min, ndist(:,2))<cellfun(@min, ndist(:,1)); 
    if any(ind1), ndist(ind1, [1,3])=cellfun(@cat, repmat({1}, length(find(ind1)),2), [num2cell(single(cellfun(@min, ndist(ind1,1)))-mult(1)), repmat({0}, size(find(ind1)))],...
        ndist(ind1,[1,3]), 'UniformOutput', 0); end
    ind1=cellfun(@max, ndist(:,2))>cellfun(@max, ndist(:,1)); 
    if any(ind1)
    ndist(ind1, [1,3])=cellfun(@cat, repmat({1}, length(find(ind1)),2), ndist(ind1,[1,3]), [num2cell(single(cellfun(@max, ndist(ind1,1)))+mult(1)),...
        repmat({0}, size(find(ind1)))], 'UniformOutput', 0); clear ind1
    end
     ndist(:,3)=cellfun(@interp1, ndist(:,1), ndist(:,3), ndist(:,2), 'UniformOutput', 0);
    ind(~ind,2)=rem(dist(~ind, j), mult(3)); 
        tmass=sum(dist(tind(:,1), [1:j-1, j+1:end]),2); 
    frac=[frac(all(~ind,2)); repmat(frac(ind(:,2))/2, 2,1); cell2mat(cellfun(@times, ndist(:,3), num2cell(accumarray(repelem((1:size(tind,1))', diff(tind, [], 2)+1,1),...
        (repelem(tmass, diff(tind, [], 2)+1, 1)+dist(ind(:,1), j)).*frac(ind(:,1)))./(cellfun(@mtimes, cellfun(@transpose, ndist(:,2), 'UniformOutput', 0),...
        ndist(:,3))+tmass.*cellfun(@sum, ndist(:,3)))), 'UniformOutput', 0))];
     ndist(:,[1,3])=[]; tind(:,3)=cellfun('size', ndist, 1); clear tdist
    dist=[dist(all(~ind,2), :); [dist(ind(:,2), 1:j-1), floor(dist(ind(:,2), j)/mult(3))*mult(3), dist(ind(:,2), j+1:end)]; [dist(ind(:,2), 1:j-1),...
        ceil(dist(ind(:,2), j)/mult(3))*mult(3), dist(ind(:,2), j+1:end)]; [repelem(dist(tind(:,1), 1:j-1), tind(:,3), 1), cell2mat(ndist),...
        repelem(dist(tind(:,1), j+1:end), tind(:,3),1)]];
end

if contains(class(mmd.mass{1}), 'uint8'), dist=uint8(dist); elseif contains(class(mmd.mass{1}), 'uint16'), dist=uint16(dist); elseif contains(class(mmd.mass{1}), 'uint32'), 
    dist=uint16(dist); end 
dist=dist/mult(1); 

mmd=cleanbranch(table({dist}, {frac/(sum(dist, 2)'*frac)*(sum(mmd.mass{1},2)'*mmd.frac{1})}, 'VariableNames', {'mass', 'frac'}, 'RowNames', mmd.Properties.RowNames), 'noflip');
end
