scanno=[212966];
//scanno=[58210,58222,58232];
//scanno=[58244,58265,58272,58284,58293,58305]; // Scan no. to be extracted. Example [18460], [18460:2:18466]
//sliceno=[]; // Slices to be extracted. Examples: [],[13,14,15], [1:24]

nxsdir="C:\Users\sgljone9\Dropbox\i09_Jan22\Data\";
fixedmode=0;
stacksize('max');

deteff_scanno=[72773];//[72718,72719];//[72726];
//Background scan in fixed mode (0.3 mm slit) for C 1s: 72718 and 72719; 
//Background scan in fixed mode (0.8 mm slit) for C 1s: 72773; 
//Background scan in fixed mode for N 1s: 72726;

detpix1=61;
deteff0=[];
if fixedmode==1 then
    for i=1:size(deteff_scanno,2);
        deteff_file=nxsdir+"i09-"+string(deteff_scanno(i))+".nxs";
        b1=h5open(deteff_file);
        b2=b1.root.entry1.instrument;
        b3=h5ls(b2);
        j=1;
        b4=h5get(b2,b3(j,1));
        while size(h5ls(b4),1)<20
            j=j+1;           
            b4=h5get(b2,b3(j,1));
        end
        deteff1=b4.spectrum_data.data;
//    deteff_energies=b4.energies.data;
        h5close(b1);
        detpix2=size(deteff1,1)-detpix1+1;
        deteff1=deteff1(detpix1:detpix2,1);
//        deteff1=deteff1/max(deteff1);
        deteff0=deteff0+deteff1;
//    deteff_energies=deteff_energies(detpix1:detpix2,1);
    end
end
deteff0=deteff0/max(deteff0);

txtprefix="i09-"+string(scanno(1));
if size(scanno,2)>1 then
    txtprefix="i09-"+string(scanno(1))+"-"+string(scanno(size(scanno,2)));
end

txtdir=nxsdir+txtprefix+"-txt";
//txtdir=nxsdir;

for i=1:size(scanno,2)
    nxsfile=nxsdir+"i09-"+string(scanno(i))+".nxs";
    if fileinfo(nxsfile)==[] then
        mprintf("\n\n File %s does not exit!",nxsfile);
        mprintf("\n Please make sure the nxs file has been copied to the processing folder.\n\n");
        abort;
    end
end

if ~isdir(txtdir) then
    createdir(txtdir);
end

txtdir=nxsdir+txtprefix+"-txt\";
r=[];
I0=[];
I0n=[];
drain=[];
regions0=[];

for i=1:size(scanno,2)
    nxsfile=nxsdir+"i09-"+string(scanno(i))+".nxs";
    a1=h5open(nxsfile);
    a2=a1.root.entry1.instrument;
    a3=h5ls(a2);

    regions=[];
    for j=1:size(a3,1)-1
        a4=h5get(a2,a3(j,1));
        if size(h5ls(a4),1)>20 then            
            regions=[regions;[j,size(a4.image_data.data)]];
        end
    end
    
    if i==1 then
        regions0=regions;
        d4=size(regions0,1); // Number of regions
        d3=regions0(1,4); // Number of photon energies
        for j=2:d4
            if regions0(j,4)<>d3 then
                mprintf(" The 3rd dimension of the image data must be the same across the regions!");
                abort;
            end
        end
        d1=max(regions0(:,2)); // Max. number of kinetic/binding energies
        d2=max(regions0(:,3)); // Max. number of angular slices
        xps4=zeros(d1,d2,d3,d4);
        ep=zeros(d3,1);
        eb=zeros(d1,d4);
    else 
        if regions<>regions0 then 
            mprintf("\n\n Scan %d does not have the same regions as the other scans!\n", scanno(i));
            abort;end
    end
    
    if find(h5ls(a2)=='nixswr')<>[] then r=r+a2.nixswr.nixswr.data';end

    if (find(h5ls(a2)=='smpmiamp39')<>[]) then drain=drain+a2.smpmiamp39.smpmiamp39.data';
    elseif (find(h5ls(a2)=='smpmamp39')<>[]) then drain=drain+a2.smpmamp39.smpmamp39.data';end

    if (find(h5ls(a2)=='hm3iamp20')<>[]) then I0=I0+a2.hm3iamp20.hm3iamp20.data';
    elseif (find(h5ls(a2)=='hm3amp20')<>[]) then I0=I0+a2.hm3amp20.hm3amp20.data';
    elseif (find(h5ls(a2)=='sm5iamp8')<>[]) then I0=I0+a2.sm5iamp8.sm5iamp8.data';
    elseif (find(h5ls(a2)=='sm5amp8')<>[]) then I0=I0+a2.sm5amp8.sm5amp8.data';end
    
    if d4==1 then
        a4=h5get(a2,a3(regions(1,1),1));
        xps4=xps4+a4.image_data.data;
        ep=ep+a4.excitation_energy.data';
        eb=eb+a4.energies.data;
    else
        for j=1:d4
            a4=h5get(a2,a3(regions(j,1),1));
            xps4(1:regions0(j,2),1:regions0(j,3),1:regions0(j,4),j)=xps4(1:regions0(j,2),1:regions0(j,3),1:regions0(j,4),j)+a4.image_data.data;
            if j==1 then ep=ep+a4.excitation_energy.data';end
            eb(1:regions0(j,2),j)=eb(1:regions0(j,2),j)+a4.energies.data;end;end
    h5close(a1);
end;

rfile=txtdir+txtprefix+"-r.txt";
dfile=txtdir+txtprefix+"-d.txt";
I0file=txtdir+txtprefix+"-I0.txt";

ep=ep/size(scanno,2);
eb=eb/size(scanno,2);
if I0<>[] & find(I0==0)==[] then
    I0n=I0/(sum(I0)/d3);
//    fprintfMat(I0file,[ep,I0n]);
    end
if r<>[] then
    if I0<>[] then
        rn=r./I0n;
        fprintfMat(rfile,[ep,rn]);
    else
        fprintfMat(rfile,[ep,r]);end;end
if drain<>[] then
    if I0<>[] then
        drainn=drain./I0n;
        fprintfMat(dfile,[ep,drainn]);
    else
        fprintfMat(dfile,[ep,drain]);end;end

for i=1:size(I0n,1)
    if d4==1 then
        xps4(:,:,i)=xps4(:,:,i)./I0n(i,1);
    else
        xps4(:,:,i,:)=xps4(:,:,i,:)./I0n(i,1);
    end;end;

mprintf("\n\nRegion_No  Region_name  Eb/Ek_steps  Slices  Ep_steps");
for i=1:d4
mprintf("  \n     %d      %s        %d         %d       %d",i,a3(regions(i,1),1),regions(i,2),regions(i,3),regions(i,4));
end

mprintf("\n\n")
if d4==1 then
    outputr=1;
else
    outputr=input(" Region to be extracted (enter 0 to abort): ");
end

while outputr<>0
    if find([1:d4]==outputr)==[] then
        mprintf(" Valid number(s): ");
        for i=1:d4
            mprintf("%d ",i);
        end
        mprintf("\n\n");
    else
//        if sum(eb(:,outputr))/size(eb,1)>700 then
            deteff=deteff0(:,1);
//        else deteff=deteff0(:,2);end
        slice1=1;
        slice2=1;
        if regions0(outputr,3)>1 then
            slice1=input(" Lower limit of slices to be summed(1 - "+string(regions0(outputr,3))+") or 0 to abort: ");
            while slice1<1|slice1>regions0(outputr,3)
                if slice1==0 then abort;end
                slice1=input(" Lower limit of slices to be summed(1 - "+string(regions0(outputr,3))+") or 0 to abort: ");
            end
            slice2=input(" Upper limit of slices to be summed(1 - "+string(regions0(outputr,3))+") or 0 to abort: ");
            while slice2<1|slice2>regions0(outputr,3)
                if slice2==0 then abort;end
                slice2=input(" Upper limit of slices to be summed(1 - "+string(regions0(outputr,3))+") or 0 to abort: ");
            end
            if slice2<slice1 then
                slice3=slice1;
                slice1=slice2;
                slice2=slice3;
            end;end;
        xpsesum=[];
        for i=1:regions0(outputr,4)
            findex=strsplit(string(1000+i));
            findexa1=strsplit(string(1000+slice1));
            findexa2=strsplit(string(1000+slice2));
            txtfile0=txtdir+txtprefix+"_"+a3(regions(outputr,1),1)+"_a"+findexa1(2)+findexa1(3)+findexa1(4)+"-"+findexa2(2)+findexa2(3)+findexa2(4);
            txtfile=txtfile0+"_e"+findex(3)+findex(4)+".txt";
            if d4==1 then
                if fixedmode==1 then
                    fprintfMat(txtfile,[eb(detpix1:detpix2),sum(xps4(detpix1:detpix2,slice1:slice2,i),'c')./deteff]);
                    xpsesum=xpsesum+sum(xps4(detpix1:detpix2,slice1:slice2,i),'c')./deteff;
                else
                        fprintfMat(txtfile,[eb,sum(xps4(:,slice1:slice2,i),'c')]);
                        xpsesum=xpsesum+sum(xps4(:,slice1:slice2,i),'c');end;
            else
                if fixedmode==1 then
                    xps1=sum(xps4(detpix1:detpix2,slice1:slice2,i,outputr),'c')./deteff;
                    fprintfMat(txtfile,[eb(detpix1:detpix2,outputr),xps1]);
                else
                    xps1=sum(xps4(:,slice1:slice2,i,outputr),'c');
                    fprintfMat(txtfile,[eb(1:regions0(outputr,2),outputr),xps1(1:regions0(outputr,2))]);end;
                xpsesum=xpsesum+xps1;end
        end
        txtfilesum=txtfile0+"_esum.txt";
        if regions(outputr,4)>1 then
            if fixedmode==1 then
                fprintfMat(txtfilesum,[eb(detpix1:detpix2,outputr),xpsesum(:,1)]);
            else
                fprintfMat(txtfilesum,[eb(1:regions0(outputr,2),outputr),xpsesum(1:regions0(outputr,2))]);end;end;
    end
    mprintf("\n");
    if d4>1 then
        outputr=input(" Region to be extracted (enter 0 to exit): ");
    elseif d4==1&d2>1 then
    else abort; end
end

//

