% function plotting_control()
clear
cases = [1 20;
    6 8 ;
    8 1 ;
    13 21 ];
C1 = clock;
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Set the trials for the specifications
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
spec_Aa = 25:-5:5; % percentage
spec_Ca(:,1) = 0.75/180*pi:0.25/180*pi:0.25/180*pi*7; %rads
spec_Ca(:,2) = 0.25:0.05:0.45; %m/s
spec_Ca(:,3) = 0.25:0.05:0.45; %m/s
spec_Ca(:,4) = 0.25:0.05:0.45; %m/s
spec_Ga = 1:1:5; %m
spec_Na = [5 5 5 5 5];%5:-1:1; %m
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Create the matrix of specifications to hand
%% to the parpool
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
spec_trials = create_spec_mat(spec_Aa,spec_Ca,spec_Ga,spec_Na);
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Set the extracted cases to plot
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
extracts = [1 35 7 35 7 10 10 35;
    7 20 7 35 7 10 7 60;
    7 30 6 10 7 10 8 330 ;
    13 355 16 30 7 10 11 60];
[starts,goals] = setup_positions();
[wd,ws,ws_interval,wd_interval] = setup_environment();
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Plots all routes
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% parfor case_num = 1:1:4
%     outputfolder = sprintf('D:/003_ORCA Data Backup/Trex for paper/TrexSet%d',case_num);
%     plotting3(starts(cases(case_num,1),:),goals(cases(case_num,2),:),outputfolder,ws,wd)
%     sprintf('Routes plotting complete %d',case_num)
% end
% return
for spec_trial_num = 17:1:17%length(spec_trials)
    for case_num = 1:1:1
        %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% Setup folders for the output
        %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        outputfolder_trial = sprintf('./ORCA_Data/TrexSet%d/trial%d',case_num,spec_trial_num);
        outputfolder = sprintf('./ORCA_Data/TrexSet%d',case_num);
        result = isfolder(outputfolder_trial);
        if result == false
            mkdir(outputfolder_trial);
            foldername = strcat(outputfolder_trial,'/data_perf');
            mkdir(foldername);
        else
        end
        %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% Analyse response of UAV
        %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        Perf_analysis(outputfolder,...
            spec_trials(spec_trial_num,1),...
            spec_trials(spec_trial_num,2:5),...
            spec_trials(spec_trial_num,6),...
            spec_trials(spec_trial_num,7),...
            outputfolder_trial)
        sprintf('Perf Analysis complete %d',case_num)
        %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% Plots OEs
        %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        plotting2(starts(cases(case_num,1),:),...
            goals(cases(case_num,2),:),...
            outputfolder_trial,...
            ws,wd,ws_interval,...
            outputfolder_trial,...
            case_num)
        sprintf('OE plotting complete %d',case_num)
        %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% Plot extracted cases
        %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        plotting4_v2(starts(cases(case_num,1),:),goals(cases(case_num,2),:),outputfolder,ws,wd,...
            spec_trials(spec_trial_num,1),...
            spec_trials(spec_trial_num,2:5),...
            spec_trials(spec_trial_num,6),...
            spec_trials(spec_trial_num,7),extracts(case_num,:),outputfolder_trial)
        sprintf('Extracted cases plotting complete %d',case_num)
    end
end
% return
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Plot the combinations of the metrics
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for case_num = 3:1:3
    [starts,goals] = setup_positions();
    [wd,ws,ws_interval,wd_interval] = setup_environment();
    outputfolder = sprintf('E:/003_ORCA Data Backup/Trex for paper/TrexSet%d',case_num);
    plotting5(outputfolder,case_num,spec_trials,starts(cases(case_num,1),:),goals(cases(case_num,2),:),ws,wd)
end
close all
C2 = clock;
time_taken = C2-C1; % calc time taken to analyse and plot
% return