%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Title: Parallel running of simulink models
%% Author: Vince
%% Date: 09/03/2020
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear
clc
%%
addpath(genpath('./000_Liear_Models/'))
addpath(genpath('./001_ORCA_Demo_2/'))
addpath(genpath('./002_Parallel_Setup/'))
addpath(genpath('./003_PerfGNC/'))
addpath(genpath('./004_Sim_Prep/'))
addpath(genpath('./temp/'))
% return
%%
global num_workers ;
tic
time_start = toc;
%%
% clean_data_folders
% clear_up_files(num_workers)
%%
% return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Setup and start the parallel pool of workers.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
disp('Starting setup...')
num_workers = setup_parallel();
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Setup the ROS Master (currently not used).
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% if  exist('Msg_AgentToAPI_Beliefs') == true
% else
%     ROS_Master_Setup
%     pause(1)
% end
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Create the callback functions that are called
%% as each message enters the queues.
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
create_feedback_functions(num_workers)
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Create the queues
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[q,qt,qr] = setup_queues(num_workers);
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%3 0
%% Setup the experimental parameters to be simmulated.
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[starts,goals] = setup_positions();
[wd,ws] = setup_environment();
numstarts = length(starts);
numgoals = length(goals);
create_models(num_workers)
t = setup_timer_function();
cases = [1 20;
    6 8;
    8 1;
    13 21];
start(t)
for case_num = 1:1:1
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% Setup the batches to run on each worker
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    outputfolder = sprintf('./ORCA_Data/TrexSet%d',case_num);
    [batch,batch_s] = create_batches(starts(cases(case_num,1),:),...
        goals(cases(case_num,2),:),...
        wd(1:1:length(wd)),...
        ws(1:1:length(ws)),...
        num_workers);
    disp('...setup complete.')
    time_para_setup = toc - time_start;
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% Start the sims on the workers.
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    disp('Starting processes...')
    spmd
        for i = 1:1:num_workers
            if labindex == i
                % labindex = 20
                filename = sprintf('trex_aug_schedule%d',labindex);
                %% Assign the queues to the worker.
                qlab = q(labindex);
                qtlab = qt(labindex);
                qrlab = qr(labindex);
                %% Start the sim.
                sim_para_main(  batch(1:batch_s(labindex),1:2,labindex),...
                    batch(1:batch_s(labindex),3:4,labindex),...
                    batch(1:batch_s(labindex),5,labindex),...
                    batch(1:batch_s(labindex),6,labindex),...
                    qlab,qtlab,qrlab,filename,labindex,...
                    outputfolder)
                message = sprintf('Sims Complete.          ');
                send(qlab,message)
                c = clock;
                simtime = sprintf('%f',c(3)*24*60*60+c(4)*60*60+c(5)*60+c(6));
                send(qtlab,simtime)
                %             disp('finished_batch')
                %             disp(i)
            end
        end
    end
    time_sim_runs = toc - time_para_setup;
end
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% stop and delete the timer function
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
pause(1)
stop(t)
delete(t)

toc
disp('...processes complete.')
fclose all

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Delete the callback functions to keep 
%% the directory neat.
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear_up_files(num_workers)
fclose all
% return
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% run the analysis and plotting scripts
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
plotting_control()
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% The End
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%