function [theta,mag,wsdiscard,wddiscard] = prep_results(wd,wdsort,wssort,interval)
% polarscatter(deg2rad(wdsort),wssort)
% hold on
% find the number of unique wind directions
nn = ones(1,length(unique(wdsort)));
% find the length of each segment of the matrix that a individual wind
% speed applies to.
ind = 1;
for i = 1:1:length(wdsort)-1
    if wdsort(i+1) == wdsort(i)
        nn(ind) = nn(ind)+1;
    else
        ind = ind +1;
    end
end
% start counters
skip = 0;
ind = 1;
indd = 1;
% intialisze output
wsdiscard = 0;
wddiscard = 0;
% find the max wind speed with no gaps for each wind direction
for i = 1:1:length(nn) % iterates over the number of segments.
    wssortnew(1+skip:skip + nn(i)) = sort(wssort(1+skip:skip + nn(i)));
    mag(ind) = 0 ;
    for j = 1:1:nn(i)-1 % iterates over the length of the segment
        % If the difference between the current and next wind speed is
        % greater than the interval in the setup, then there is a void in
        % the stable simulation field. Therefore, this becomes the limit.
        
        if wssortnew(1+skip+j) - wssortnew(1+skip+j-1) > interval
            % assign the current wind speed as the new limit.
            mag(ind) = wssortnew(1+skip+j-1);
            % find the discarded wind speeds and directions
            for k = j:1:j-1+length(wssortnew(1+skip+j:skip + nn(i))) % iterates over the length of the segment
                wsdiscard(indd) = wssortnew(1+skip+k);
                wddiscard(indd) = max(wdsort(1+skip:skip + nn(i)));
                indd = indd + 1;
            end
            break
        else
            mag(ind) = wssortnew(1+skip+j);
        end
    end
    %     [mag(ind),I] = max(wssortnew(1+skip:skip + nn(i)));
    theta(ind) = max(wdsort(1+skip:skip + nn(i)));
    % Increment counters
    skip = skip + nn(i);
    ind = ind + 1;
end
% Add extra element to complete circuit
theta(length(theta)+1) = theta(1);
mag(length(mag)+1) = mag(1);
% polarscatter(deg2rad(theta),mag)
return