function [final_route,num_waypoints,coord_sel] = prep_result_plan(filename)
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Set constant and initialise variables 
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
size_grid = 4356;
final_route = zeros(1,size_grid);
coord_sel = zeros(size_grid,2);
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% open and read text file
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fid = fopen(filename,'r');
str = fread(fid);
fclose(fid);
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% convert string into vector
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
str = char(str(:).');
idx = isstrprop(str,'wspace');
idy = diff([true,idx,true]);
idb = find(idy<0);
ide = find(idy>0)-1;
num = numel(idb);
out = nan(num,1);
for k = 1:num
    out(k) = str2double(str(idb(k):ide(k)));
end
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% reassign outout to relevant vectors
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
num_waypoints = out(1);
final_route(1,1:num_waypoints) = out(2:num_waypoints+1);
ind = 1;
for k = num_waypoints+2:2:num-1
    coord_sel(ind,1) = out(k);
    coord_sel(ind,2) = out(k+1);
    ind = ind + 1;
end
return