function plotOEs(A,C,G,N,wd,ws,test,outputfolder,wstest,wdtest,ws_interval,case_num)
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
directionTravel = calc_angle(test);
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot_stable_envelope
maxWS = 20;%max(ws);
comb = (A+C+G+N)/4; %combine metrics
% I = not(isnan(comb)); %find nans
[wdsort,I] = sort(wd); %sort wind direction vector
wssort = ws(I); % reorder wind speed vector based on wind direction vector
% combsort  = comb(I); % reorder metric vec based on wind direction vector
% combI = not(isnan(combsort)); % find nans
% find max wind speed for each wind direction vector
[theta,mag,wsdiscard,wddiscard] = prep_results(wd,wdsort,wssort,ws_interval);
figure('units','centimeters','Position',[0,0,8.6,8.6+3])
%%
nnn = length(theta);
mmm = length(mag);
thetaA = zeros(1,nnn);
thetaC = zeros(1,nnn);
thetaG = zeros(1,nnn);
thetaN = zeros(1,nnn);
magA = zeros(1,mmm);
magC = zeros(1,mmm);
magG = zeros(1,mmm);
magN = zeros(1,mmm);
%% plot tested conditions
ind = 1;
for i = 1:1:length(wstest)
    for j = 1:1:length(wdtest)
        wstested(ind) = wstest(i);
        wdtested(ind) = wdtest(j);
        ind = ind + 1;
    end
end
p = polarscatter(deg2rad(wdtested),wstested,6*ones(1,length(wstested)),'filled');
p.MarkerEdgeAlpha = 0.75;
p.MarkerFaceColor = [0.5 0.5 0.5];
% p.MarkerSize = 1;
p.LineWidth = 0.125/2;
p.MarkerFaceAlpha = 0.5;
hold on
% subplot(2,3,1)
%% plot contiguous conditions
p = polarscatter(deg2rad(wdsort),wssort,6*ones(1,length(wssort)),'filled');
p.MarkerEdgeAlpha = 0.75;
p.MarkerFaceColor = [0 0.5 0];
p.LineWidth = 0.125/2;
p.MarkerFaceAlpha = 0.5;
hold on
%% plot stable conditions
p = polarscatter(deg2rad(wddiscard),wsdiscard,6*ones(1,length(wsdiscard)),'filled');
p.MarkerEdgeAlpha = 0.5;
p.MarkerFaceAlpha = 0.5;
p.MarkerFaceColor = [0 0 1];
p.LineWidth = 0.125/2;
hold on
%%
    thetaf = deg2rad(theta(1));
    magf  = mag(1);
    for j = 2:1:length(mag)
        thetaf = [thetaf,[deg2rad(theta(j)-2.5) deg2rad(theta(j)+2.5)]];
        magf = [magf,[mag(j) mag(j)]];
    end
% p = polarplot(thetaf,magf,'LineWidth',1);
% p.Color = [1 0 0];
% p.LineWidth = 2;
t = title(strcat('Case Number = ',num2str(case_num)));
pax = gca;
pax.Position = [0.111538461538461,0.309969210474919,0.775,0.567312854655277];
pax.ThetaDir = 'clockwise';
pax.ThetaZeroLocation = 'top';
pax.FontWeight = 'bold';
pax.FontName = 'Palatino Linotype';
pax.FontSize = 10;
pax.RAxis.Color = [1 0 0];
pax.RAxis.Label.String = 'Wind Speed (Kts)';
% pax.RAxis.Label.Position.HorizontalAlignment = 'center';
pax.RAxis.Label.Position = [180.3281875588289,57.17081977264492,0];
pax.RAxis.Label.Color = [1 0 0];
pax.RAxis.Label.Rotation = 0;
pax.RAxis.Label.FontSize  = 10;
pax.RAxisLocation = 190;
pax.RAxis.Label.HorizontalAlignment = 'center';
pax.RAxis.Label.VerticalAlignment = 'bottom';
rticks([0:5:40]);
pax.RLim = [0 40];
pax.RMinorGrid = 'on';
thetaticks(0:15:360)
pax.ThetaAxis.Color = [0 0 1] ;
pax.ThetaAxis.Label.FontSize  = 10;
pax.ThetaAxis.Label.String = 'Wind Direction (\circ)';
% pax.ThetaAxis.Label.Position.HorizontalAlignment = 'center';
pax.ThetaAxis.Label.Position = [0,52.06737918238485,-1.4e-14];
pax.ThetaAxis.Label.HorizontalAlignment = 'center';
pax.ThetaAxis.Label.VerticalAlignment = 'top';
pax.ThetaAxis.Label.Rotation = 0;
pax.ThetaMinorGrid = 'on';
% pax.LineWidth = 2;
pax.GridAlpha =  0.5;
polarplotarrow(pax,deg2rad(directionTravel),40);

t.Position = [0.000029056973744,50.44504296395733,-1.4e-14];

legend('Tested','Contiguous','Discarded','Direction of Travel')
legend('Location','southoutside')
legend('boxoff')
legend('NumColumns',2)
legend('Position',[0.070769246266438,0.027427458839611,0.833846138348947,0.17230768763102])
hold off
clear theta mag
filename = '/OEs.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'painters');
exportgraphics(gcf,filename,'Resolution',300)
% export_fig(filename,'-png')
% return
%%
%%
%%
%%
clearvars wssort wdsort comb combI combsort p1 p2 p3 t pax fig
fig = figure('units','centimeters','Position',[0,0,8.6,8.6+1]);
comb = (A); %combine metrics
% I = not(isnan(comb)); %find nans
[wdsort,I] = sort(wd); %sort wind direction vector
wssort = ws(I); % reorder wind speed vector based on wind direction vector
combsort  = comb(I); % reorder metric vec based on wind direction vector
combI = not(isnan(combsort)); % find nans
if length(wdsort(combI)) == 0 % checks to see if any sims satisfied the condition
    wdsort = 0;
    wssort = 0;
    thetaA = zeros(1,nnn);
    magA = zeros(1,mmm);
else
    [thetaA,magA,~,~] = prep_results(wd(combI),wdsort(combI),wssort(combI),ws_interval);
end
p1 = polarscatter(deg2rad(wdsort(combI)),wssort(combI),6*ones(1,length(wssort(combI))),'filled');
hold on
    thetaf = deg2rad(thetaA(1));
    magf  = magA(1);
    for j = 2:1:length(magA)
        thetaf = [thetaf,[deg2rad(thetaA(j)-2.5) deg2rad(thetaA(j)+2.5)]];
        magf = [magf,[magA(j) magA(j)]];
    end
p2 = polarplot(thetaf,magf,'LineWidth',1);
t = title('Actuator Metric');
pax = gca;
pax.GridAlpha =  0.5;
polarplotarrow(pax,deg2rad(directionTravel),maxWS);
format_plot(fig,p1,t,p2,pax)
rticks([0:5:20]);
pax.RLim = [0 20];
hold off
clear theta mag
filename = '/OEsAct.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'painters');
exportgraphics(gcf,filename,'Resolution',300)
%%
%%
%%
clearvars wssort wdsort comb combI combsort p1 p2 p3 t pax fig
fig = figure('units','centimeters','Position',[0,0,8.6,8.6+1]);
comb = (C); %combine metrics
% I = not(isnan(comb)); %find nans
[wdsort,I] = sort(wd); %sort wind direction vector
wssort = ws(I); % reorder wind speed vector based on wind direction vector
combsort  = comb(I); % reorder metric vec based on wind direction vector
combI = not(isnan(combsort)); % find nans
if length(wdsort(combI)) == 0 % checks to see if any sims satisfied the condition
    wdsort = 0;
    wssort = 0;
    thetaC = zeros(1,nnn);
    magC = zeros(1,mmm);
else
    [thetaC,magC,~,~] = prep_results(wd(combI),wdsort(combI),wssort(combI),ws_interval);
end
p1 = polarscatter(deg2rad(wdsort(combI)),wssort(combI),6*ones(1,length(wssort(combI))),'filled');
hold on
    thetaf = deg2rad(thetaC(1));
    magf  = magC(1);
    for j = 2:1:length(magC)
        thetaf = [thetaf,[deg2rad(thetaC(j)-2.5) deg2rad(thetaC(j)+2.5)]];
        magf = [magf,[magC(j) magC(j)]];
    end
p2 = polarplot(thetaf,magf,'LineWidth',1);
t = title('Controller Metric');
pax = gca;
pax.GridAlpha =  0.5;
polarplotarrow(pax,deg2rad(directionTravel),maxWS);
format_plot(fig,p1,t,p2,pax)
rticks([0:5:20]);
pax.RLim = [0 20];
hold off
clear theta mag
filename = '/OEsCon.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'painters');
exportgraphics(gcf,filename,'Resolution',300)
%%
%%
%%
clearvars wssort wdsort comb combI combsort p1 p2 p3 t pax fig
fig = figure('units','centimeters','Position',[0,0,8.6,8.6+1]);
comb = (G); %combine metrics
% I = not(isnan(comb)); %find nans
[wdsort,I] = sort(wd); %sort wind direction vector
wssort = ws(I); % reorder wind speed vector based on wind direction vector
combsort  = comb(I); % reorder metric vec based on wind direction vector
combI = not(isnan(combsort)); % find nans
if length(wdsort(combI)) == 0 % checks to see if any sims satisfied the condition
    wdsort = 0;
    wssort = 0;
    thetaG = zeros(1,nnn);
    magG = zeros(1,mmm);
else
    [thetaG,magG,~,~] = prep_results(wd,wdsort(combI),wssort(combI),ws_interval);
end
p1 = polarscatter(deg2rad(wdsort(combI)),wssort(combI),6*ones(1,length(wssort(combI))),'filled');
hold on
    thetaf = deg2rad(thetaG(1));
    magf  = magG(1);
    for j = 2:1:length(magG)
        thetaf = [thetaf,[deg2rad(thetaG(j)-2.5) deg2rad(thetaG(j)+2.5)]];
        magf = [magf,[magG(j) magG(j)]];
    end
p2 = polarplot(thetaf,magf,'LineWidth',1);
t = title('Guidance Metric');
t.Position = [0.000053931527646,52.427244489178335,0];
pax = gca;
pax.GridAlpha =  0.5;
polarplotarrow(pax,deg2rad(directionTravel),maxWS);
format_plot(fig,p1,t,p2,pax)
rticks([0:5:20]);
pax.RLim = [0 20];
hold off
clear theta mag
filename = '/OEsGui.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'painters');
exportgraphics(gcf,filename,'Resolution',300)
%%
%%
%%
clearvars wssort wdsort comb combI combsort p1 p2 p3 t pax fig
fig = figure('units','centimeters','Position',[0,0,8.6,8.6+1]);
comb = (N); %combine metrics
% I = not(isnan(comb)); %find nans
[wdsort,I] = sort(wd); %sort wind direction vector
wssort = ws(I); % reorder wind speed vector based on wind direction vector
combsort  = comb(I); % reorder metric vec based on wind direction vector
combI = not(isnan(combsort)); % find nans
if length(wdsort(combI)) == 0 % checks to see if any sims satisfied the condition
    wdsort = 0;
    wssort = 0;
    thetaN = zeros(1,nnn);
    magN = zeros(1,mmm);
else
    [thetaN,magN,~,~] = prep_results(wd,wdsort(combI),wssort(combI),ws_interval);
end
p1 = polarscatter(deg2rad(wdsort),wssort,6*ones(1,length(wssort)),'filled');
hold on
    thetaf = deg2rad(thetaN(1));
    magf  = magN(1);
    for j = 2:1:length(magN)
        thetaf = [thetaf,[deg2rad(thetaN(j)-2.5) deg2rad(thetaN(j)+2.5)]];
        magf = [magf,[magN(j) magN(j)]];
    end
p2 = polarplot(thetaf,magf,'LineWidth',1);
t = title('Navigation Metric');

pax = gca;
pax.GridAlpha =  0.5;
polarplotarrow(pax,deg2rad(directionTravel),maxWS);

format_plot(fig,p1,t,p2,pax)
rticks([0:5:20]);
pax.RLim = [0 20];
clear theta mag
filename = '/OEsNav.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'painters');
exportgraphics(gcf,filename,'Resolution',300)
%%
%%
%%
% subplot(2,3,6)
figure('units','centimeters','Position',[0,0,8.6,8.6+3])
polarscatter([0],[0],6*ones(1,1),'filled','r');
hold on
polarscatter([0],[0],6*ones(1,1),'filled','g');
polarscatter([0],[0],6*ones(1,1),'filled','b');
polarscatter([0],[0],6*ones(1,1),'filled','k');
clearvars thetaf magf
thetaf = deg2rad(thetaA(1)+2.5);
magf  = magA(1);
for j = 2:1:length(magA)
    thetaf = [thetaf,[deg2rad(thetaA(j)-2.5) deg2rad(thetaA(j)+2.5)]];
    magf = [magf,[magA(j) magA(j)]];
end
polarplot(thetaf,magf,'LineWidth',1,'color','r');
% polarplot(deg2rad(thetaA),magA,'LineWidth',2,'Linestyle',':')
hold on
clearvars thetaf magf
thetaf = deg2rad(thetaC(1)+2.5);
magf  = magC(1);
for j = 2:1:length(magC)
    thetaf = [thetaf,[deg2rad(thetaC(j)-2.5) deg2rad(thetaC(j)+2.5)]];
    magf = [magf,[magC(j) magC(j)]];
end
polarplot(thetaf,magf,'LineWidth',1,'color','g');
% polarplot(deg2rad(thetaC),magC,'LineWidth',2,'Linestyle','-')
hold on
clearvars thetaf magf
thetaf = deg2rad(thetaG(1)+2.5);
magf  = magG(1);
for j = 2:1:length(magG)
    thetaf = [thetaf,[deg2rad(thetaG(j)-2.5) deg2rad(thetaG(j)+2.5)]];
    magf = [magf,[magG(j) magG(j)]];
end
polarplot(thetaf,magf,'LineWidth',1,'color','b');
% polarplot(deg2rad(thetaG),magG,'LineWidth',2,'Linestyle','-.')
% hold on
%     thetaf = deg2rad(thetaN(1));
%     magf  = magN(1);
%     for j = 2:1:length(magN)
%         thetaf = [thetaf,[deg2rad(thetaN(j)-2.5) deg2rad(thetaN(j)+2.5)]];
%         magf = [magf,[magN(j) magN(j)]];
%     end
% polarplot(thetaf,magf,'LineWidth',1);
% polarplot(deg2rad(thetaN),magN,'LineWidth',2,'Linestyle','--')
hold on

pax = gca;
pax.GridAlpha =  0.5;
pax.FontWeight = 'bold';
pax.FontName = 'Palatino Linotype';
pax.FontSize = 10;
% pax.Position = [0.117692307692308,0.142227631231367,0.775,0.815];
pax.Position = [0.117692307692308,0.142227631231367,0.775,0.815];
pax.ThetaDir = 'clockwise';
pax.ThetaZeroLocation = 'top';
pax.FontWeight = 'bold';
pax.RAxis.Color = [1 0 0];
pax.RAxis.Label.String = 'Wind Speed (Kts)';
% pax.RAxis.Label.Position.HorizontalAlignment = 'center';
% pax.RAxis.Label.Position = [181.93737804228,53.21181794539463,1.443289932012704e-14];
pax.RAxis.Label.Position = [183.8356067706379,26.892431388236016,1.443289932012704e-14];
pax.RAxis.Label.Color = [1 0 0];
pax.RAxis.Label.Rotation = 0;
pax.RAxis.Label.FontSize  = 10;
pax.RAxisLocation = 190;
pax.RAxis.Label.HorizontalAlignment = 'center';
pax.RAxis.Label.VerticalAlignment = 'bottom';
rticks([0:5:20])
pax.RLim = [0 20];
pax.RMinorGrid = 'on';
thetaticks(0:15:360)
pax.ThetaAxis.Color = [0 0 1] ;
pax.ThetaAxis.Label.FontSize  = 10;
pax.ThetaAxis.Label.String = 'Wind Direction (\circ)';
% pax.ThetaAxis.Label.Position.HorizontalAlignment = 'center';
% pax.ThetaAxis.Label.Position = [360,53.7566,1.4433e-14];
pax.ThetaAxis.Label.Position = [360,27.089945853702606,1.443289932012704e-14];
pax.ThetaAxis.Label.HorizontalAlignment = 'center';
pax.ThetaAxis.Label.VerticalAlignment = 'top';
pax.ThetaAxis.Label.Rotation = 0;
polarplotarrow(pax,deg2rad(directionTravel),maxWS);
% 1 35 5 35 10 35
p4 = polarscatter(deg2rad([30 10 10 330]),[7 6 7 8],40*ones(1,4),'x','filled','LineWidth',2,'MarkerEdgeColor','k');

lgd = legend('Actuator','Controller','Guidance','Direction of Travel');
lgd.Title.String = 'Envelope drawn by:';
legend('Location','southoutside')
legend('boxoff')
legend('NumColumns',2)
legend('Position',[0.067692323189515,0.006879513634132,0.833846138348947,0.17230768763102])

t = title(strcat('Overlapping Envelopes for Case =',num2str(case_num)));
t.Position = [0.000055158281782,26.574074502987546,1.4e-14];
% t.Position = [359.6682816637711,54.828962384994895,1.443289932012704e-14];
filename = '/OEsCom.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'opengl');
exportgraphics(gcf,filename,'Resolution',300)

%% Save boundaries to txt file.
filename = '/boundaryA.txt';
filename = strcat(outputfolder,filename);
writematrix([transpose(thetaA),transpose(magA)],filename,'Delimiter','tab');
filename = '/boundaryC.txt';
filename = strcat(outputfolder,filename);
writematrix([transpose(thetaC),transpose(magC)],filename,'Delimiter','tab');
filename = '/boundaryG.txt';
filename = strcat(outputfolder,filename);
writematrix([transpose(thetaG),transpose(magG)],filename,'Delimiter','tab');
filename = '/boundaryN.txt';
filename = strcat(outputfolder,filename);
writematrix([transpose(thetaN),transpose(magN)],filename,'Delimiter','tab');
return