function sim_para_main(starts,goals,wd,ws,q,qt,qr,filenamemodel,labindex,outoutfolder)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Load the simulink model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% global fidmat ;
load('Bbase.mat');
load('Abase.mat');
load('trimbase.mat');
load('kbase.mat');
message = sprintf('Loading model...          ');
send(q,message)
sys = load_system(filenamemodel);
warning('off','all')
message = sprintf('...model loaded .         ');
send(q,message)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Loop over the number on condiations handed
%% to the worker.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[n,~] = size(starts);
for i = 1:1:n
%     try
        run = sprintf('%s',num2str(i));
        send(qr,run)
        message = sprintf('Setting conditions... ');
        send(q,message)
        [A,B,C,D,E,k,...
            int_x,int_y,int_z,...
            int_u,int_v,int_w,...
            int_phitrim,int_thetatrim,int_psi,...
            Abase,Bbase,trimbase,kbase,op_points,...
            fwda,wsa,wda,...
            int_lat,int_long,int_coll,int_pedal,...
            route,coord,Num_Way_Points,...
            start_direction,end_direction,...
            start_speed,end_speed,...
            change_time] = set_conditions(starts(i,:),goals(i,:),wd(i),ws(i));
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% Start the simulation
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        message = sprintf('Starting model...     ');
        send(q,message)
        c = clock;
        simtime = sprintf('%s',num2str(c(3)*24*60*60+c(4)*60*60+c(5)*60+c(6)));
        send(qt,simtime)
        in = Simulink.SimulationInput(filenamemodel);
        in = in.setVariable('Abase',Abase,'Workspace',filenamemodel);
        in = in.setVariable('Bbase',Bbase,'Workspace',filenamemodel);
        in = in.setVariable('trimbase',trimbase,'Workspace',filenamemodel);
        in = in.setVariable('op_points',op_points,'Workspace',filenamemodel);
        in = in.setVariable('fwda',fwda,'Workspace',filenamemodel);
        in = in.setVariable('wda',wda,'Workspace',filenamemodel);
        in = in.setVariable('wsa',wsa,'Workspace',filenamemodel);
        in = in.setVariable('kbase',kbase,'Workspace',filenamemodel);
        in = in.setVariable('A',A,'Workspace',filenamemodel);
        in = in.setVariable('B',B,'Workspace',filenamemodel);
        in = in.setVariable('C',C,'Workspace',filenamemodel);
        in = in.setVariable('D',D,'Workspace',filenamemodel);
        in = in.setVariable('k',k,'Workspace',filenamemodel);
        in = in.setVariable('int_x',int_x,'Workspace',filenamemodel);
        in = in.setVariable('int_y',int_y,'Workspace',filenamemodel);
        in = in.setVariable('int_z',int_z,'Workspace',filenamemodel);
        in = in.setVariable('int_u',int_u,'Workspace',filenamemodel);
        in = in.setVariable('int_v',int_v,'Workspace',filenamemodel);
        in = in.setVariable('int_w',int_w,'Workspace',filenamemodel);
        in = in.setVariable('int_phitrim',int_phitrim,'Workspace',filenamemodel);
        in = in.setVariable('int_thetatrim',int_thetatrim,'Workspace',filenamemodel);
        in = in.setVariable('int_psi',int_psi,'Workspace',filenamemodel);
        in = in.setVariable('int_lat',int_lat,'Workspace',filenamemodel);
        in = in.setVariable('int_long',int_long,'Workspace',filenamemodel);
        in = in.setVariable('int_coll',int_coll,'Workspace',filenamemodel);
        in = in.setVariable('int_pedal',int_pedal,'Workspace',filenamemodel);
        in = in.setVariable('E',E,'Workspace',filenamemodel);
        in = in.setVariable('start_speed',start_speed,'Workspace',filenamemodel);
        in = in.setVariable('end_speed',end_speed,'Workspace',filenamemodel);
        in = in.setVariable('start_direction',start_direction,'Workspace',filenamemodel);
        in = in.setVariable('end_direction',end_direction,'Workspace',filenamemodel);
        in = in.setVariable('change_time',change_time,'Workspace',filenamemodel);
        in = in.setVariable('route',route,'Workspace',filenamemodel);
        in = in.setVariable('coord',coord,'Workspace',filenamemodel);
        in = in.setVariable('Num_Way_Points',Num_Way_Points,'Workspace',filenamemodel);
        message = sprintf('...model params set     ');
        send(q,message)
        out = sim(in);
        message = sprintf('...model finished.     ');
        send(q,message)
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% Save the simultion results
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        if out.critical_failiure == true || out.mission_complete ~= true
        else
            message = sprintf('Saving response...     ');
            send(q,message)
            filename = sprintf('/data/s_%s_%s_g_%s_%s_wd_%s_ws_%s_response.txt',num2str(starts(i,1))...
                ,num2str(starts(i,2))...
                ,num2str(goals(i,1))...
                ,num2str(goals(i,2))...
                ,num2str(wd(i))...
                ,num2str(ws(i)));
            filename = strcat(outoutfolder,filename);
            fid = fopen(filename,'w');
            writematrix([out.time,...
                out.phi,out.theta,out.psia,...
                out.u,out.v,out.w,...
                out.uref,out.vref,out.wref,...
                out.x,out.y,out.z,...
                out.xref,out.yref,out.zref,...
                out.psiref,...
                out.lat,out.long,out.coll,out.pedal],...
                filename,...
                'Delimiter','tab')
            filename = sprintf('/data/s_%s_%s_g_%s_%s_wd_%s_ws_%s_plan.txt',num2str(starts(i,1))...
                ,num2str(starts(i,2))...
                ,num2str(goals(i,1))...
                ,num2str(goals(i,2))...
                ,num2str(wd(i))...
                ,num2str(ws(i)));
            filename = strcat(outoutfolder,filename);
            fid = fopen(filename,'w');
            fprintf(fid,'%f \n',Num_Way_Points);
            for ii = 1:1:Num_Way_Points
                fprintf(fid,'%f \t',route(ii));
            end
            fprintf(fid,'\n');
            for ii = 1:1:length(coord)
                fprintf(fid,'%f \t %f \n',coord(ii,1),coord(ii,2));
            end
            fclose all;
        end
        quiver(out.x(2:250:length(out.x)),out.y(2:250:length(out.x)),1*cos(out.psia(2:250:length(out.x))),1*sin(out.psia(2:250:length(out.x))))
        plot(out.x(2:100:length(out.x)),out.y(2:100:length(out.x)))
        hold off
        xlim([50 180]);
        ylim([50 180]);
        filename = sprintf('/graphs/startcond_%s_%s_%s_%s',mat2str(starts(i,:)),mat2str(goals(i,:)),mat2str(ws(i)),mat2str(wd(i)));
        filename = strcat(outoutfolder,filename);
        set(gcf,'color','w');
        set(gca, 'Color', 'white');
        export_fig(filename,'-jpg')
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% Stop the simulation.
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        message = sprintf('Sim complete.    ');
        send(q,message)
        set_param(sys,'SimulationCommand','stop');
%     catch MException
% %         disp(MException)
%         filename = sprintf('/log_%d_s_%d_%d_g_%d_%d_wd_%d_ws_%d.txt',labindex,starts(i,1),starts(i,2),goals(i,1),goals(i,2),wd(i),ws(i));
%         filename = strcat(outoutfolder,filename);
%         fid2 = fopen(filename,'w');
%         fprintf(fid2,'%s',MException.message);
% %         for e=1:length(MException.stack)
% %             fprintf(fid,'%sin %s at %i\n',txt,MException.stack(e).name,MException.stack(e).line);
% %         end
%         fclose all;
%     end
end
return