function psi_error = psi_dif_prep(psi,psi_ref)
psi_error = zeros(1,length(psi));
for i = 1:1:length(psi)
    q1=angle2quat(psi(i),0,0);
    q2=angle2quat(psi_ref(i),0,0);
    q3=QuatDivide(q1,q2);
    [r,~,~]=quat2angle(transpose(q3));
    psi_error(i) = sqrt((r)^2);
end
end
function q = angle2quat(z, y, x)
%ANGLE2QUAT Convert Euler angles to a quaternion.
%   Q = ANGLE2QUAT(Z, Y, X) converts Euler angles Z, Y, X, into an
%   equivalent quaternion Q.

thetas = [z(:) y(:) x(:)];

c = cos(thetas/2);
s = sin(thetas/2);

q = [c(:,1).*c(:,2).*c(:,3) + s(:,1).*s(:,2).*s(:,3), ...
    c(:,1).*c(:,2).*s(:,3) - s(:,1).*s(:,2).*c(:,3), ...
    c(:,1).*s(:,2).*c(:,3) + s(:,1).*c(:,2).*s(:,3), ...
    s(:,1).*c(:,2).*c(:,3) - c(:,1).*s(:,2).*s(:,3)];
end

function [z,y,x] = quat2angle(q)
%QUAT2ANGLE Convert quaternion to Euler angles.
%   [Z Y X] = QUAT2ANGLE(Q) calculates the Euler angles, Z, Y, X, for a
%   quaternion, Q.

qn = quatnormalize(q);
z = atan2(2.*(qn(:,2).*qn(:,3) + qn(:,1).*qn(:,4)), ...
    qn(:,1).^2 + qn(:,2).^2 - qn(:,3).^2 - qn(:,4).^2);
y = asin(-2.*(qn(:,2).*qn(:,4) - qn(:,1).*qn(:,3)));
x = atan2(2.*(qn(:,3).*qn(:,4) + qn(:,1).*qn(:,2)), ...
    qn(:,1).^2 - qn(:,2).^2 - qn(:,3).^2 + qn(:,4).^2);
end

function q_out = QuatDivide(qin1,qin2)
q_out = zeros(4,1);

q0 = qin1(1);
q1 = qin1(2);
q2 = qin1(3);
q3 = qin1(4);

r0 = qin2(1);
r1 = qin2(2);
r2 = qin2(3);
r3 = qin2(4);

q_out(1,1) = (qin2(1)*qin1(1) + qin2(2)*qin1(2) + qin2(3)*qin1(3) + qin2(4)*qin1(4));
q_out(2,1) = (r0*q1 - r1*q0 - r2*q3 + r3*q2);
q_out(3,1) = (r0*q2 + r1*q3 - r2*q0 - r3*q1);
q_out(4,1) = (r0*q3 - r1*q2 + r2*q1 - r3*q0);
end