function plotting5(outputfolder,case_num,spec_trial,start,goal,ws,wd)
test = goal-start;
maxWS = 20;%max(ws);
directionTravel = calc_angle(test);
fig = figure('units','centimeters','Position',[0,0,8.6,8.6+3]);colorvec = ['r','g','b','m','c'];
for i = 1:1:5
    p1 = polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',colorvec(i));
    hold on
end
polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',[0 0 0]);
pax = gca;
ind = 1;
for i = 1:1:5
    outputfolder_trial = sprintf('E:/003_ORCA Data Backup/Trex for paper/TrexSet%d/trial%d',case_num,i);
    filename = '/boundaryA.txt';
    filename = strcat(outputfolder_trial,filename);
    boundary = readmatrix(filename);
    theta = boundary(:,1);
    mag = boundary(:,2);
    p1 = polarscatter(0,0,6*ones(1,1),'filled');
    hold on
    colorvec = {'r','g','b','m','c'};
    linesepc = {'-','--',':','-.','-'};
    thetaf = deg2rad(theta(1)+2.5);
    magf  = mag(1);
    for j = 2:1:length(mag)
        thetaf = [thetaf,[deg2rad(theta(j)-2.5) deg2rad(theta(j)+2.5)]];
        magf = [magf,[mag(j) mag(j)]];
    end
    p2 = polarplot(thetaf,magf,'LineWidth',1,'Color',colorvec{ind});%,'Linestyle',linesepc{ind});
    hold on
    t = title(strcat('Actuator Metric Case = ',num2str(case_num)));
    polarplotarrow(pax,deg2rad(directionTravel),maxWS);
    pax = gca;
    format_plot(fig,p1,t,p2,pax)
    ind = ind + 1;
end
rticks([0:5:20]);
pax.RLim = [0 20];
pax.Position = [0.117692307692308,0.142227631231367,0.775,0.815];
hold off

for i = 1:1:5
    lll{i} = num2str(spec_trial(i,1));
    lll{i} = strcat(lll{i},' %');
end
lll{6} = 'Direction of Travel';
    lgd = legend(lll{1},lll{2},lll{3},lll{4},lll{5},lll{6});
    lgd.Title.String = 'Envelope for specified performance of:';
%     legend('Most Restrictive','High','Middle','Low','Least Restrictive')
    legend('Location','southoutside')
    legend('boxoff')
    legend('NumColumns',2)
    legend('Position',[0.067692323189515,0.006879513634132,0.833846138348947,0.17230768763102])
clear theta mag
filename = '/OEsActTrials.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'painters');
exportgraphics(gcf,filename,'Resolution',300)
clearvars boundary theta mag

fig = figure('units','centimeters','Position',[0,0,8.6,8.6+3]);
colorvec = ['r','g','b','m','c'];
for i = 1:1:5
    p1 = polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',colorvec(i));
    hold on
end
polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',[0 0 0]);
ind = 1;
pax = gca;
for i = 6:1:10
    outputfolder_trial = sprintf('E:/003_ORCA Data Backup/Trex for paper/TrexSet%d/trial%d',case_num,i);
    filename = '/boundaryC.txt';
    filename = strcat(outputfolder_trial,filename);
    boundary = readmatrix(filename);
    theta = boundary(:,1);
    mag = boundary(:,2);
    p1 = polarscatter(0,0,6*ones(1,1),'filled');
    hold on
    colorvec = {'r','g','b','m','c'};
    linesepc = {'-','--',':','-.','-'};
    thetaf = deg2rad(theta(1)+2.5);
    magf  = mag(1);
    for j = 2:1:length(mag)
        thetaf = [thetaf,[deg2rad(theta(j)-2.5) deg2rad(theta(j)+2.5)]];
        magf = [magf,[mag(j) mag(j)]];
    end
    p2 = polarplot(thetaf,magf,'LineWidth',1,'Color',colorvec{ind});%,'Linestyle',linesepc{ind});
    hold on
    t = title(strcat('Controller Heading Metric Case = ',num2str(case_num)));
    polarplotarrow(pax,deg2rad(directionTravel),maxWS);
    pax = gca;
    format_plot(fig,p1,t,p2,pax)
    ind = ind + 1;
end
rticks([0:5:20]);
pax.RLim = [0 20];
pax.Position = [0.117692307692308,0.142227631231367,0.775,0.815];
hold off
for i = 1:1:5
    lll{i} = num2str(rad2deg(spec_trial(i+5,2)));
    lll{i} = strcat(lll{i},' deg');
end
lll{6} = 'Direction of Travel';
    lgd = legend(lll{1},lll{2},lll{3},lll{4},lll{5},lll{6});
    lgd.Title.String = 'Envelope for specified performance of:';
    legend('Location','southoutside')
    legend('boxoff')
    legend('NumColumns',2)
    legend('Position',[0.067692323189515,0.006879513634132,0.833846138348947,0.17230768763102])
clear theta mag
filename = '/OEsCon1Trials.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'painters');
exportgraphics(gcf,filename,'Resolution',300)

fig = figure('units','centimeters','Position',[0,0,8.6,8.6+3]);
colorvec = ['r','g','b','m','c'];
for i = 1:1:5
    p1 = polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',colorvec(i));
    hold on
end
polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',[0 0 0]);
ind = 1;
pax = gca;
for i = 11:1:15
    outputfolder_trial = sprintf('E:/003_ORCA Data Backup/Trex for paper/TrexSet%d/trial%d',case_num,i);
    filename = '/boundaryC.txt';
    filename = strcat(outputfolder_trial,filename);
    boundary = readmatrix(filename);
    theta = boundary(:,1);
    mag = boundary(:,2);
    p1 = polarscatter(0,0,6*ones(1,1),'filled');
    hold on
    colorvec = {'r','g','b','m','c'};
    linesepc = {'-','--',':','-.','-'};
    thetaf = deg2rad(theta(1)+2.5);
    magf  = mag(1);
    for j = 2:1:length(mag)
        thetaf = [thetaf,[deg2rad(theta(j)-2.5) deg2rad(theta(j)+2.5)]];
        magf = [magf,[mag(j) mag(j)]];
    end
    p2 = polarplot(thetaf,magf,'LineWidth',1,'Color',colorvec{ind});%,'Linestyle',linesepc{ind});
    hold on
    t = title(strcat('Controller u,v,w Metric Case = ',num2str(case_num)));
    polarplotarrow(pax,deg2rad(directionTravel),maxWS);
    pax = gca;
    format_plot(fig,p1,t,p2,pax)
    ind = ind + 1;
end
rticks([0:5:20]);
pax.RLim = [0 20];
pax.Position = [0.117692307692308,0.142227631231367,0.775,0.815];
hold off
for i = 1:1:5
    lll{i} = num2str(spec_trial(i+10,3));
    lll{i} = strcat(lll{i},' m/s');
end
lll{6} = 'Direction of Travel';
    lgd = legend(lll{1},lll{2},lll{3},lll{4},lll{5},lll{6});
    lgd.Title.String = 'Envelope for specified performance of:';
    legend('Location','southoutside')
    legend('boxoff')
    legend('NumColumns',2)
    legend('Position',[0.067692323189515,0.006879513634132,0.833846138348947,0.17230768763102])
clear theta mag
filename = '/OEsCon2Trials.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'painters');
exportgraphics(gcf,filename,'Resolution',300)

fig = figure('units','centimeters','Position',[0,0,8.6,8.6+3]);
colorvec = ['r','g','b','m','c'];
for i = 1:1:5
    p1 = polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',colorvec(i));
    hold on
end
polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',[0 0 0]);
ind = 1;
pax = gca;
for i = 16:1:20
    outputfolder_trial = sprintf('E:/003_ORCA Data Backup/Trex for paper/TrexSet%d/trial%d',case_num,i);
    filename = '/boundaryG.txt';
    filename = strcat(outputfolder_trial,filename);
    boundary = readmatrix(filename);
    theta = boundary(:,1);
    mag = boundary(:,2);
    p1 = polarscatter(0,0,6*ones(1,1),'filled');
    hold on
    colorvec = {'r','g','b','m','c'};
    linesepc = {'-','--',':','-.','-'};
    thetaf = deg2rad(theta(1)+2.5);
    magf  = mag(1);
    for j = 2:1:length(mag)
        thetaf = [thetaf,[deg2rad(theta(j)-2.5) deg2rad(theta(j)+2.5)]];
        magf = [magf,[mag(j) mag(j)]];
    end
    p2 = polarplot(thetaf,magf,'LineWidth',1,'Color',colorvec{ind});%,'Linestyle',linesepc{ind});
    hold on
        t = title(strcat('Guidance Metric Case = ',num2str(case_num)));
    polarplotarrow(pax,deg2rad(directionTravel),maxWS);
    pax = gca;
    format_plot(fig,p1,t,p2,pax)
    ind = ind + 1;
end
rticks([0:5:20]);
pax.RLim = [0 20];
pax.Position = [0.117692307692308,0.142227631231367,0.775,0.815];
hold off
for i = 1:1:5
    lll{i} = num2str(spec_trial(i+15,6));
    lll{i} = strcat(lll{i},' m');
end
lll{6} = 'Direction of Travel';
    lgd = legend(lll{1},lll{2},lll{3},lll{4},lll{5},lll{6});
    lgd.Title.String = 'Envelope for specified performance of:';
    legend('Location','southoutside')
    legend('boxoff')
    legend('NumColumns',2)
    legend('Position',[0.067692323189515,0.006879513634132,0.833846138348947,0.17230768763102])
clear theta mag
filename = '/OEsGuiTrials.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'painters');
exportgraphics(gcf,filename,'Resolution',300)

fig = figure('units','centimeters','Position',[0,0,8.6,8.6+3]);
colorvec = ['r','g','b','m','c'];
for i = 1:1:5
    p1 = polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',colorvec(i));
    hold on
end
polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',[0 0 0]);
ind = 1;
pax = gca;
for i = 21:1:25
    outputfolder_trial = sprintf('E:/003_ORCA Data Backup/Trex for paper/TrexSet%d/trial%d',case_num,i);
    filename = '/boundaryN.txt';
    filename = strcat(outputfolder_trial,filename);
    boundary = readmatrix(filename);
    theta = boundary(:,1);
    mag = boundary(:,2);
    p1 = polarscatter(0,0,6*ones(1,1),'filled');
    hold on
    colorvec = {'r','g','b','m','c'};
    linesepc = {'-','--',':','-.','-'};
    thetaf = deg2rad(theta(1)+2.5);
    magf  = mag(1);
    for j = 2:1:length(mag)
        thetaf = [thetaf,[deg2rad(theta(j)-2.5) deg2rad(theta(j)+2.5)]];
        magf = [magf,[mag(j) mag(j)]];
    end
    p2 = polarplot(thetaf,magf,'LineWidth',1,'Color',colorvec{ind});%,'Linestyle',linesepc{ind});
    hold on
    t = title(strcat('Navigation Metric Case = ',num2str(case_num)));
    polarplotarrow(pax,deg2rad(directionTravel),maxWS);
    pax = gca;
    %     format_plot(fig,p1,t,p2,p3,pax)
    ind = ind + 1;
end
pax = gca;
rticks([0:5:20]);
pax.RLim = [0 20];
pax.Position = [0.117692307692308,0.142227631231367,0.775,0.815];
hold off
for i = 1:1:5
    lll{i} = num2str(spec_trial(i+20,7));
    lll{i} = strcat(lll{i},' m');
end
lll{6} = 'Direction of Travel';
    lgd = legend(lll{1},lll{2},lll{3},lll{4},lll{5},lll{6});
    lgd.Title.String = 'Envelope for specified performance of:';
    legend('Location','southoutside')
    legend('boxoff')
    legend('NumColumns',2)
    legend('Position',[0.067692323189515,0.006879513634132,0.833846138348947,0.17230768763102])
clear theta mag
filename = '/OEsNavTrials.png';
filename = strcat(outputfolder,filename);
set(gcf,'color','w');
set(gca, 'Color', 'white');
set(gcf, 'Renderer', 'painters');
exportgraphics(gcf,filename,'Resolution',300)



wd(end+1) = wd(1);
fig = figure('units','centimeters','Position',[0,0,8.6,8.6+3]);
for spec_trial_select = 17:1:17;
    outputfolder_trial = sprintf('E:/003_ORCA Data Backup/Trex for paper/TrexSet%d/trial%d',case_num,spec_trial_select);
    filename = '/boundaryA.txt';
    filename = strcat(outputfolder_trial,filename);
    boundaryA = readmatrix(filename);
    outputfolder_trial = sprintf('E:/003_ORCA Data Backup/Trex for paper/TrexSet%d/trial%d',case_num,spec_trial_select);
    filename = '/boundaryC.txt';
    filename = strcat(outputfolder_trial,filename);
    boundaryC = readmatrix(filename);
    outputfolder_trial = sprintf('E:/003_ORCA Data Backup/Trex for paper/TrexSet%d/trial%d',case_num,spec_trial_select);
    filename = '/boundaryG.txt';
    filename = strcat(outputfolder_trial,filename);
    boundaryG = readmatrix(filename);
%     outputfolder_trial = sprintf('C:/Users/Vince/ORCA Data/Trex/TrexSet%d/trial%d',case_num,spec_trial_select);
%     filename = '/boundaryN.txt';
%     filename = strcat(outputfolder_trial,filename);
%     boundaryN = readmatrix(filename);
    colorvec = ['r','g','b','m','c'];
    for i = 1:1:3
        p1 = polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',colorvec(i));
        hold on
    end
    p1 = polarscatter([0],[0],6*ones(1,1),'filled','MarkerFaceColor',[0 0 0]);
    p1 = polarscatter([0],[0],6*ones(1,1),'filled');
    mmm = length(wd);
    if length(boundaryA) ~= mmm || length(boundaryC) ~= mmm || length(boundaryG) ~= mmm %|| length(boundaryN) ~= mmm
        for i = 1:1:mmm
            if i > length(boundaryA(:,1))
                boundaryA(i,1) = wd(i);
                boundaryA(i,2) = 0;
            else
                if boundaryA(i,1) ~= wd(i)
                    boundaryAA(:,1) = [boundaryA(1:i-1,1);wd(i);boundaryA(i+1:end,1)];
                    boundaryAA(:,2) = [boundaryA(1:i-1,2);0;boundaryA(i+1:end,2)];
                    clearvars boundaryA
                    boundaryA = boundaryAA;
                    clearvars boundaryAA
                end
            end
            if i > length(boundaryC(:,1))
                boundaryC(i,1) = wd(i);
                boundaryC(i,2) = 0;
            else
                if boundaryC(i,1) ~= wd(i)
                    boundaryCC(:,1) = [boundaryC(1:i-1,1);wd(i);boundaryC(i+1:end,1)];
                    boundaryCC(:,2) = [boundaryC(1:i-1,2); 0;boundaryC(i+1:end,2)];
                    clearvars boundaryC
                    boundaryC = boundaryCC;
                    clearvars boundaryCC
                end
            end
            if i > length(boundaryG(:,1))
                boundaryG(i,1) = wd(i);
                boundaryG(i,2) = 0;
            else
                if boundaryG(i,1) ~= wd(i)
                    boundaryGG(:,1) = [boundaryG(1:i-1,1);wd(i);boundaryG(i+1:end,1)];
                    boundaryGG(:,2) = [boundaryG(1:i-1,2); 0;boundaryG(i+1:end,2)];
                    clearvars boundaryG
                    boundaryG = boundaryGG;
                    clearvars boundaryGG
                end
            end
%             if i > length(boundaryN(:,1))
%                 boundaryN(i,1) = wd(i);
%                 boundaryN(i,2) = 0;
%             else
%                 if boundaryN(i,1) ~= wd(i)
%                     boundaryNN(:,1) = [boundaryN(1:i-1,1);wd(i);boundaryN(i:end,1)];
%                     boundaryNN(:,2) = [boundaryN(1:i-1,2); 0;boundaryN(i:end,2)];
%                     clearvars boundaryN
%                     boundaryN = boundaryNN;
%                     clearvars boundaryNN
%                 end
%             end
        end
    end
    
    for i = 1:1:length(wd)
        [mag(i),I] =  min([boundaryA(i,2) boundaryC(i,2) boundaryG(i,2)]);% boundaryN(i,2)]);
        theta(i) = boundaryA(i,1);
        if i > 1
            if I == 1
                p2 = polarplot([deg2rad(theta(i-1)+2.5) deg2rad(theta(i)-2.5) deg2rad(theta(i)+2.5)],[mag(i-1) mag(i) mag(i)],'LineWidth',1,'Color','r');
                hold on
            elseif I == 2
                p2 = polarplot([deg2rad(theta(i-1)+2.5) deg2rad(theta(i)-2.5) deg2rad(theta(i)+2.5)],[mag(i-1) mag(i) mag(i)],'LineWidth',1,'Color','g');
                hold on
            elseif I == 3
                p2 = polarplot([deg2rad(theta(i-1)+2.5) deg2rad(theta(i)-2.5) deg2rad(theta(i)+2.5)],[mag(i-1) mag(i) mag(i)],'LineWidth',1,'Color','b');
                hold on
%             elseif I == 4
%                 p2 = polarplot([deg2rad(theta(i-1)+2.5) deg2rad(theta(i)-2.5) deg2rad(theta(i)+2.5)],[mag(i-1) mag(i) mag(i)],'LineWidth',1,'Color','m');
%                 hold on
            end
        end
    end
    
    hold on
    %     p2 = polarplot(deg2rad(theta),mag,'LineWidth',2);
    %     hold on
%     t = title('Combined Metrics');
    t = title(strcat('Overlapping Envelopes Case = ',num2str(case_num)));
    pax = gca;
    format_plot(fig,p1,t,p2,pax)
    % stop = 0;
    % ind = 1;
    % while stop == 0
    %
    % end
    pax = gca;
    pax.FontWeight = 'bold';
    pax.FontName = 'Palatino Linotype';
    pax.FontSize = 10;
    pax.Position = [0.117692307692308,0.142227631231367,0.775,0.815];
    pax.ThetaDir = 'clockwise';
    pax.ThetaZeroLocation = 'top';
    pax.FontWeight = 'bold';
    pax.RAxis.Color = [1 0 0];
    pax.RAxis.Label.String = 'Wind Speed (Kts)';
    % pax.RAxis.Label.Position.HorizontalAlignment = 'center';
    pax.RAxis.Label.Position = [183.8356067706379,26.892431388236016,1.443289932012704e-14];
    pax.RAxis.Label.Color = [1 0 0];
    pax.RAxis.Label.Rotation = 0;
    pax.RAxis.Label.FontSize  = 10;
    pax.RAxisLocation = 190;
    pax.RAxis.Label.HorizontalAlignment = 'center';
    pax.RAxis.Label.VerticalAlignment = 'bottom';
    rticks([0:5:20])
    pax.RLim = [0 20];
    pax.RMinorGrid = 'on';
    thetaticks(0:15:360)
    pax.ThetaAxis.Color = [0 0 1] ;
    pax.ThetaAxis.Label.FontSize  = 10;
    pax.ThetaAxis.Label.String = 'Wind Direction (\circ)';
    % pax.ThetaAxis.Label.Position.HorizontalAlignment = 'center';
    pax.ThetaAxis.Label.Position = [360,27.089945853702606,1.443289932012704e-14];
    pax.ThetaAxis.Label.HorizontalAlignment = 'center';
    pax.ThetaAxis.Label.VerticalAlignment = 'top';
    pax.ThetaAxis.Label.Rotation = 0;
    polarplotarrow(pax,deg2rad(directionTravel),maxWS);
%     p3 = polarplot([deg2rad(directionTravel) deg2rad(directionTravel)],[maxWS 0],'color',[ 1 1 1]);
%     p3.LineStyle = '-';
%     p3.Marker = 'o';
%     p3.LineWidth = 1;
%     p3.MarkerIndices = 1;
%     p3.MarkerFaceColor = [0 0 0];
%     p3.MarkerEdgeColor = [0 0 0];
%     p3.Color = [0 0 0];
    
    polarscatter(deg2rad([30 10 10 330]),[7 6 7 8],40*ones(1,4),'x','filled','LineWidth',2,'MarkerEdgeColor','k');
    
    lgd = legend('Actuator','Controller','Guidance','Direction of Travel');
    lgd.Title.String = 'Envelope limited by:';
    legend('Location','southoutside')
    legend('boxoff')
    legend('NumColumns',2)
    legend('Position',[0.067692323189515,0.006879513634132,0.833846138348947,0.17230768763102])
    
        t.Position = [0.000055158281782,26.574074502987546,1.4e-14];
    
    hold off
    clear theta mag
    filename = sprintf('/OEsCombinedFinal%d.png',spec_trial_select);
    filename = strcat(outputfolder,filename);
    set(gcf,'color','w');
    set(gca, 'Color', 'white');
    set(gcf, 'Renderer', 'opengl');
    exportgraphics(gcf,filename,'Resolution',300)
end

return