function plotting4_v2(start,goal,outputfolder,wstest,wdtest,spec_A,spec_C,spec_G,spec_N,extract,outputfolder_trial)
clearvars -EXCEPT start goal outputfolder wstest wdtest spec_A spec_C spec_G spec_N extract outputfolder_trial
close all
[n,m] = size(extract);
colorvec = [[1 0 0];[1 0 0];[0 0 1];[0 0 1];[0 0 1];[0 0 1];[0 1 0];[0 1 0]];
% 'color',colorvec(ii)
figxy = figure('units','centimeters','Position',[0,0,14-2.7*2+3.08,14-2.7*2+3.08]);
figxya = gca;
% dusplay shape
scatter(figxya,start(1),start(2),'MarkerEdgeColor',colorvec(1,:),'MarkerFaceColor',colorvec(1,:));
hold on
scatter(figxya,start(1),start(2),'MarkerEdgeColor',colorvec(3,:),'MarkerFaceColor',colorvec(3,:));
scatter(figxya,start(1),start(2),'MarkerEdgeColor',colorvec(5,:),'MarkerFaceColor',colorvec(5,:));
[cond] = set_cond(0,0);
grid_spacing = cond.world.grid_spacing;
[~,obj,~] = setup(grid_spacing,cond);
disp_shape(obj)
xlim(figxya,[50 200])
ylim(figxya,[50 200])
hold on
% figuuref = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
% figuurefa = gca;
% hold on
% figvvref = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
% figvvrefa = gca;
% hold on
% figwwref = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
% figwwrefa = gca;
% hold on
% figpsipsiref = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
% figpsipsirefa = gca;
% hold on
% figlat = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
% figlata = gca;
% hold on
% figlong = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
% figlonga = gca;
% hold on
% figcoll = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
% figcolla = gca;
% hold on
% figpedal = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
% figpedala = gca;
% hold on
% figperpmag = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
% figperpmaga = gca;
% hold on
% figprox = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
% figproxa = gca;
% hold on

for ii = 1:2:m
    figuuref = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
figuurefa = gca;
hold on
figvvref = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
figvvrefa = gca;
hold on
figwwref = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
figwwrefa = gca;
hold on
figpsipsiref = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
figpsipsirefa = gca;
hold on
figlat = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
figlata = gca;
hold on
figlong = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
figlonga = gca;
hold on
figcoll = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
figcolla = gca;
hold on
figpedal = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
figpedala = gca;
hold on
figperpmag = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6]);
figperpmaga = gca;
hold on
figprox = figure('units','centimeters','Position',[0,0,21-2.7*2+3.08,8.6/2]);
figproxa = gca;
hold on
    % [starts,goals] = setup_positions();
    % start = starts(1,:); goal = goals(20,:);
    % close all
    wsextract = extract(ii);
    wdextract = extract(ii+1);
    %%
    folder = strcat(outputfolder,'/data');
    files = dir(folder);
    ind = 1;
    for i = 4:2:length(files)
        %% read file name and extract conditions used for sim run
        filename = sprintf('/data/%s',files(i).name);
        filename = strcat(outputfolder,filename);
        [wsstr,wdstr,g,s] = extract_name_plotting2(filename);
        wd = str2double(wdstr);
        ws = str2double(wsstr);
        if wd == wdextract && ws == wsextract
            break
        else
        end
    end
    response = readmatrix(filename);
    time = response(:,1);
    %     phi = response(:,2);
    %     theta = response(:,3);
    psia = response(:,4);
    u = response(:,5);
    v = response(:,6);
    w = response(:,7);
    uref = response(:,8);
    vref = response(:,9);
    wref = response(:,10);
    x = response(:,11);
    y = response(:,12);
    z = response(:,13);
    xref = response(:,14);
    yref = response(:,15);
    zref = response(:,16);
    psiref = response(:,17);
    lat = response(:,18);
    long = response(:,19);
    coll = response(:,20);
    pedal = response(:,21);
    %%
    %%
    %%
    
    
    % gca = figxya;
    
    hold on
    % dsplay route
    
    xref(1) = start(1);
    yref(1) = start(2);
    
    x(1) = start(1);
    y(1) = start(2);
    p = plot(figxya,xref,yref,x,y,'Linewidth',1);
    set(p(2),'color',colorvec(ii,:))
    set(p(1),'LineStyle',':')
    set(p(1),'color','k')
    hold on
    view(figxya,[90 -90])
    ylabel(figxya,'East (m)')
    xlabel(figxya,'North (m)')
    xlim(figxya,[50 200])
    ylim(figxya,[50 200])
    xticks(figxya,50:10:200)
    yticks(figxya,50:10:200)
    axis(figxya,'square')
    grid(figxya,'on')
    grid(figxya,'minor')
    hold on
    p = figxya;
    p.FontWeight = 'bold';
    p.FontName = 'Palatino Linotype';
    p.FontSize = 10;
    legend(figxya,...
        sprintf('A Extract V_w = %s %s_w = %s',num2str(extract(1,1)),'\psi',num2str(extract(1,2))),...
        sprintf('B Extract V_w = %s %s_w = %s',num2str(extract(1,3)),'\psi',num2str(extract(1,4))),...
        sprintf('C Extract V_w = %s %s_w = %s',num2str(extract(1,5)),'\psi',num2str(extract(1,6))));
    %     lgd.Title.String = 'Envelope limited by:';
    legend(figxya,'Location','southoutside')
    legend(figxya,'boxoff')
    %     legend(figxya,'Orientation','Horizontal')
    legend(figxya,'NumColumns',2)
    filename = 'x_y.png';
    filename = strcat(outputfolder_trial,filename);
    set(figxy,'color','w');
    set(figxya, 'Color', 'white');
    set(figxya,'FontWeight','bold');
    set(figxya,'FontName','Palatino Linotype');
    set(figxya,'FontSize',10);
    set(figxy,'Renderer', 'opengl');
    exportgraphics(figxy,filename,'Resolution',600)
    %%
    %%
    %%
    [segment_times_straight,~,~,~] = segment_mission(xref,yref,time);
    %%
    %%
    %%
    
    p = plot(figuurefa,time,sqrt((u-uref).^2),'color',colorvec(ii,:),'Linewidth',1);
    hold on
    plot(figuurefa,[0 time(end)],[spec_C(2) spec_C(2)],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    % set(p(2),'LineStyle','-.')
    
    line = max(sqrt((u-uref).^2));
    for i = 1:1:length(segment_times_straight)
        plot(figuurefa,[segment_times_straight(i,2) segment_times_straight(i,2)],[line line*1.1],'color',[0.5 0.5 0.5],'Linewidth',2)
    end
    hold on
    xlabel(figuurefa,'Time (s)')
    ylabel(figuurefa,{'u_g error (m/s)'})
    
    limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    xlim(figuurefa,[0 lim])
    p = figuurefa;
    p.FontWeight = 'bold';
    p.FontName = 'Palatino Linotype';
    p.FontSize = 10;
    grid(figuurefa,'on')
    grid(figuurefa,'minor')
    hold on
    filename = sprintf('u_uref%d.png',ii);
    filename = strcat(outputfolder_trial,filename);
    set(figuuref,'color','w');
    set(figuurefa, 'Color', 'white');
    set(figuurefa,'FontWeight','bold');
    set(figuurefa,'FontName','Palatino Linotype');
    set(figuurefa,'FontSize',10);
    set(figuuref,'Renderer', 'opengl');
    exportgraphics(figuuref,filename,'Resolution',600)
    %%
    %%
    %%
    
    p = plot(figvvrefa,time,sqrt((v-vref).^2),'color',colorvec(ii,:),'Linewidth',1);
    plot(figvvrefa,[0 time(end)],[spec_C(3) spec_C(3)],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    % set(p(2),'LineStyle','-.')
    hold on
    line = max(sqrt((v-vref).^2));
    for i = 1:1:length(segment_times_straight)
        plot(figvvrefa,[segment_times_straight(i,2) segment_times_straight(i,2)],[line line*1.1],'color',[0.5 0.5 0.5],'Linewidth',2)
    end
    hold on
    xlabel(figvvrefa,'Time (s)')
    ylabel(figvvrefa,{'v_g Error (m/s)'})
    limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    xlim(figvvrefa,[0 lim])
    p = figvvrefa;
    p.FontWeight = 'bold';
    p.FontName = 'Palatino Linotype';
    p.FontSize = 10;
    grid(figvvrefa,'on')
    grid(figvvrefa,'minor')
    hold on
    filename = sprintf('v_vref%d.png',ii);
    filename = strcat(outputfolder_trial,filename);
    set(figvvref,'color','w');
    set(figvvrefa, 'Color', 'white');
    set(figvvrefa,'FontWeight','bold');
    set(figvvrefa,'FontName','Palatino Linotype');
    set(figvvrefa,'FontSize',10);
    set(figvvref,'Renderer', 'opengl');
    exportgraphics(figvvref,filename,'Resolution',600)
    %%
    %%
    %%
    
    p = plot(figwwrefa,time,sqrt((w-wref).^2),'color',colorvec(ii,:),'Linewidth',1);
    plot(figwwrefa,[0 time(end)],[spec_C(4) spec_C(4)],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    % set(p(2),'LineStyle','-.')
    hold on
    line = max(sqrt((w-wref).^2));
    for i = 1:1:length(segment_times_straight)
        plot(figwwrefa,[segment_times_straight(i,2) segment_times_straight(i,2)],[line line*1.1],'color',[0.5 0.5 0.5],'Linewidth',2)
    end
    hold on
    xlabel(figwwrefa,'Time (s)')
    ylabel(figwwrefa,{'w_g Error (m/s)'})
    limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    xlim(figwwrefa,[0 lim])
    p = figwwrefa;
    p.FontWeight = 'bold';
    p.FontName = 'Palatino Linotype';
    p.FontSize = 10;
    grid(figwwrefa,'on')
    grid(figwwrefa,'minor')
    hold on
    filename = sprintf('w_wref%d.png',ii);
    filename = strcat(outputfolder_trial,filename);
    set(figwwref,'color','w');
    set(figwwrefa, 'Color', 'white');
    set(figwwrefa,'FontWeight','bold');
    set(figwwrefa,'FontName','Palatino Linotype');
    set(figwwrefa,'FontSize',10);
    set(figwwref,'Renderer', 'opengl');
    exportgraphics(figwwref,filename,'Resolution',600)
    %%
    %%
    %%
    psia(1) = psia(2);
    
    psi_error = psi_dif_prep(psia,psiref);
    
    p = plot(figpsipsirefa,time,psi_error,'color',colorvec(ii,:),'Linewidth',1);
    plot(figpsipsirefa,[0 time(end)],[spec_C(1) spec_C(1)],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    % set(p(2),'LineStyle','-.')
    hold on
    line = max(psi_error);
    for i = 1:1:length(segment_times_straight)
        plot(figpsipsirefa,[segment_times_straight(i,2) segment_times_straight(i,2)],[line line*1.1],'color',[0.5 0.5 0.5],'Linewidth',2)
    end
    hold on
    xlabel(figpsipsirefa,'Time (s)')
    ylabel(figpsipsirefa,{'\psi Error (rad)'})
    limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    xlim(figpsipsirefa,[0 lim])
    p = figpsipsirefa;
    p.FontWeight = 'bold';
    p.FontName = 'Palatino Linotype';
    p.FontSize = 10;
    grid(figpsipsirefa,'on')
    grid(figpsipsirefa,'minor')
    hold on
    filename = sprintf('psi_psiref%d.png',ii);
    filename = strcat(outputfolder_trial,filename);
    set(figpsipsiref,'color','w');
    set(figpsipsirefa, 'Color', 'white');
    set(figpsipsirefa,'FontWeight','bold');
    set(figpsipsirefa,'FontName','Palatino Linotype');
    set(figpsipsirefa,'FontSize',10);
    set(figpsipsiref,'Renderer', 'opengl');
    exportgraphics(figpsipsiref,filename,'Resolution',600)
    %%
    %%
    %%
    
    lat(1) = lat(2);
    plot(figlata,time,lat,'color',colorvec(ii,:),'Linewidth',1)
    hold on
    plot(figlata,[0 time(end)],[100 100],'color',[0 0 0],'Linewidth',1)
    plot(figlata,[0 time(end)],[0 0],'color',[0 0 0],'Linewidth',1)
    plot(figlata,[0 time(end)],[100-spec_A 100-spec_A],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    plot(figlata,[0 time(end)],[spec_A spec_A],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    line = max(lat);
    for i = 1:1:length(segment_times_straight)
        plot(figlata,[segment_times_straight(i,2) segment_times_straight(i,2)],[line line*1.1],'color',[0.5 0.5 0.5],'Linewidth',2)
    end
    hold on
    xlabel(figlata,'Time (s)')
    ylabel(figlata,{'Lateral','Control (%)'})
    limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    xlim(figlata,[0 lim])
    p = figlata;
    p.FontWeight = 'bold';
    p.FontName = 'Palatino Linotype';
    p.FontSize = 10;
    grid(figlata,'on')
    grid(figlata,'minor')
    hold on
    filename = sprintf('lat%d.png',ii);
    filename = strcat(outputfolder_trial,filename);
    set(figlat,'color','w');
    set(figlata, 'Color', 'white');
    set(figlata,'FontWeight','bold');
    set(figlata,'FontName','Palatino Linotype');
    set(figlata,'FontSize',10);
    set(figlat,'Renderer', 'opengl');
    exportgraphics(figlat,filename,'Resolution',600)
    %%
    %%
    %%
    long(1) = long(2);
    
    plot(figlonga,time,long,'color',colorvec(ii,:),'Linewidth',1)
    hold on
    plot(figlonga,[0 time(end)],[100 100],'color',[0 0 0],'Linewidth',1)
    plot(figlonga,[0 time(end)],[0 0],'color',[0 0 0],'Linewidth',1)
    plot(figlonga,[0 time(end)],[100-spec_A 100-spec_A],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    plot(figlonga,[0 time(end)],[spec_A spec_A],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    line = max(long);
    for i = 1:1:length(segment_times_straight)
        plot(figlonga,[segment_times_straight(i,2) segment_times_straight(i,2)],[line line*1.1],'color',[0.5 0.5 0.5],'Linewidth',2)
    end
    hold on
    xlabel(figlonga,'Time (s)')
    ylabel(figlonga,{'Longitudinal','Control (%)'})
    limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    xlim(figlonga,[0 lim])
    p = figlonga;
    p.FontWeight = 'bold';
    p.FontName = 'Palatino Linotype';
    p.FontSize = 10;
    grid(figlonga,'on')
    grid(figlonga,'minor')
    hold on
    filename = sprintf('long%d.png',ii);
    filename = strcat(outputfolder_trial,filename);
    set(figlong,'color','w');
    set(figlonga, 'Color', 'white');
    set(figlonga,'FontWeight','bold');
    set(figlonga,'FontName','Palatino Linotype');
    set(figlonga,'FontSize',10);
    set(figlong,'Renderer', 'opengl');
    exportgraphics(figlong,filename,'Resolution',600)
    %%
    %%
    %%
    coll(1) = coll(2);
    
    plot(figcolla,time,coll,'color',colorvec(ii,:),'Linewidth',1)
    hold on
    plot(figcolla,[0 time(end)],[100 100],'color',[0 0 0],'Linewidth',1)
    plot(figcolla,[0 time(end)],[0 0],'color',[0 0 0],'Linewidth',1)
    plot(figcolla,[0 time(end)],[100-spec_A 100-spec_A],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    plot(figcolla,[0 time(end)],[spec_A spec_A],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    line = max(coll);
    for i = 1:1:length(segment_times_straight)
        plot(figcolla,[segment_times_straight(i,2) segment_times_straight(i,2)],[line line*1.1],'color',[0.5 0.5 0.5],'Linewidth',2)
    end
    hold on
    xlabel(figcolla,'Time (s)')
    ylabel(figcolla,{'Collective','Control (%)'})
    limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    xlim(figcolla,[0 lim])
    p = figcolla;
    p.FontWeight = 'bold';
    p.FontName = 'Palatino Linotype';
    p.FontSize = 10;
    grid(figcolla,'on')
    grid(figcolla,'minor')
    hold on
    filename = sprintf('coll%d.png',ii);
    filename = strcat(outputfolder_trial,filename);
    set(figcoll,'color','w');
    set(figcolla, 'Color', 'white');
    set(figcolla,'FontWeight','bold');
    set(figcolla,'FontName','Palatino Linotype');
    set(figcolla,'FontSize',10);
    set(figcoll,'Renderer', 'opengl');
    exportgraphics(figcoll,filename,'Resolution',600)
    %%
    %%
    %%
    pedal(1) = pedal(2);
    
    plot(figpedala,time,pedal,'color',colorvec(ii,:),'Linewidth',1)
    hold on
    plot(figpedala,[0 time(end)],[100 100],'color',[0 0 0],'Linewidth',1)
    plot(figpedala,[0 time(end)],[0 0],'color',[0 0 0],'Linewidth',1)
    plot(figpedala,[0 time(end)],[100-spec_A 100-spec_A],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    plot(figpedala,[0 time(end)],[spec_A spec_A],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    line = max(pedal);
    for i = 1:1:length(segment_times_straight)
        plot(figpedala,[segment_times_straight(i,2) segment_times_straight(i,2)],[line line*1.1],'color',[0.5 0.5 0.5],'Linewidth',2)
    end
    hold on
    xlabel(figpedala,'Time (s)')
    ylabel(figpedala,{'Pedal','Control (%)'})
    limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    xlim(figpedala,[0 lim])
    p = figpedala;
    p.FontWeight = 'bold';
    p.FontName = 'Palatino Linotype';
    p.FontSize = 10;
    grid(figpedala,'on')
    grid(figpedala,'minor')
    hold on
    filename = sprintf('pedal%d.png',ii);
    filename = strcat(outputfolder_trial,filename);
    set(figpedal,'color','w');
    set(figpedala, 'Color', 'white');
    set(figpedala,'FontWeight','bold');
    set(figpedala,'FontName','Palatino Linotype');
    set(figpedala,'FontSize',10);
    set(figpedal,'Renderer', 'opengl');
    exportgraphics(figpedal,filename,'Resolution',600)
    %%
    %%
    %%
    %%
    folder = strcat(outputfolder_trial,'/data_perf');
    files = dir(folder);
    
    ind = 1;
    for i = 3:5:length(files)
        %% read file name and extract conditions used for sim run
        filename = sprintf('/%s',files(i).name);
        filename = strcat(folder,filename);
        [wsstr,wdstr,g,s] = extract_name_plotting2(filename);
        wd = str2double(wdstr);
        ws = str2double(wsstr);
        if wd == wdextract && ws == wsextract
            break
        else
        end
    end
    analysis = readmatrix(filename);
    
    filename = sprintf('/%s',files(i+1).name);
    filename = strcat(folder,filename);
    cost_progress = readmatrix(filename);
    
    filename = sprintf('/%s',files(i+3).name);
    filename = strcat(folder,filename);
    segment_length = importdata(filename);
    
    filename = sprintf('/%s',files(i+4).name);
    filename = strcat(folder,filename);
    time_intervals = readmatrix(filename);
    %%
    %%
    %%
    h1 = subplot(2,1,1,'Parent',figperpmag);
    figperpmaga2 = figperpmaga;
    plot(h1,0.005:0.005:0.005*length(analysis(:,3)),analysis(:,3),'color',colorvec(ii,:),'Linewidth',1)
    hold(h1,'on')
    line = max(analysis(:,3));
    for i = 1:1:length(segment_times_straight)
        plot(h1,[segment_times_straight(i,2) segment_times_straight(i,2)],[0 4.5 ],'color',[0.5 0.5 0.5 0.5],'Linewidth',2)
        hold(h1,'on')
    end
    plot(h1,[0 time(end)],[spec_G spec_G],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    hold(h1,'off')
    h1.XAxis.Visible = 'off';
%     xlabel(h1,'Time (s)')
    ylabel(h1,{'Perpendicular', 'Distance','from path (m)'})

    limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    ylim(h1,[0 4.5])
    xlim(h1,[0 lim])
    h1.FontWeight = 'bold';
    h1.FontName = 'Palatino Linotype';
    h1.FontSize = 10;
    grid(h1,'on')
    grid(h1,'minor')
    %%
    %% 
    %%
    h2 = subplot(2,1,2,'Parent',figperpmag);
%     yyaxis(figperpmaga,'right')
    [n,~] = size(cost_progress);
    for i = 1:1:n
    plot(h2,time_intervals(i,1:segment_length(i)),cost_progress(i,1:segment_length(i)),'-b','Linewidth',2)
    hold(h2,'on')
    end
%     line = 1.2;
    for i = 1:1:length(segment_times_straight)
        plot(h2,[segment_times_straight(i,2) segment_times_straight(i,2)],[0 1.5 ],'color',[0.5 0.5 0.5 0.5],'Linewidth',2)
        hold(h2,'on')
    end
    plot(h2,[0 time(end)],[1 1],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    xlabel(h2,'Time (s)')
    ylabel(h2,{'Guidance Cost', ' Function',' Along Segment'})
        limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    xlim(h2,[0 lim])
    h2.FontWeight = 'bold';
    h2.FontName = 'Palatino Linotype';
    h2.FontSize = 10;
    hold(h2,'off')
    ylim(h2,[0 1.5])
    grid(h2,'on')
    grid(h2,'minor')
    yyaxis(h2,'right')
    for i = 1:1:n
        scatter(h2,time_intervals(i,segment_length(i)),cost_progress(i,segment_length(i)),'r','filled')
        hold(h2,'on')
    end
    hold(h2,'off')
    ylim(h2,[0 1.5])
    ylabel(h2,{'Final Cost', ' Function',' for Segment'})
    filename = sprintf('PerfMag%d.png',ii);
    filename = strcat(outputfolder_trial,filename);
    set(figperpmag,'color','w');
    set(h1, 'Color', 'white');
    set(h1,'FontWeight','bold');
    set(h1,'FontName','Palatino Linotype');
    set(h1,'FontSize',10);
        set(h2, 'Color', 'white');
    set(h2,'FontWeight','bold');
    set(h2,'FontName','Palatino Linotype');
    set(h2,'FontSize',10);
    set(figperpmag,'Renderer', 'opengl');
    exportgraphics(figperpmag,filename,'Resolution',600)
    %%
    
    plot(figproxa,0.005:0.005:0.005*length(analysis(:,1)),analysis(:,1),'color',colorvec(ii,:),'Linewidth',1)
    hold on
    line = max(analysis(:,1));
    for i = 1:1:length(segment_times_straight)
        plot(figproxa,[segment_times_straight(i,2) segment_times_straight(i,2)],[line line*1.1],'color',[0.5 0.5 0.5],'Linewidth',2)
        hold on
    end
    plot(figproxa,[0 time(end)],[spec_N spec_N],'color',[0 0 0],'Linewidth',1,'LineStyle','--')
    hold on
    xlabel(figproxa,'Time (s)')
    ylabel(figproxa,{'Proximity (m)',' ',' '})
    limtest(ii) = round(time(end),-1);
    if limtest(ii) < time(end)
        limtest(ii) = limtest(ii) + 10;
    end
    lim = max(limtest);
    xlim(figproxa,[0 lim])
    p = figproxa;
    p.FontWeight = 'bold';
    p.FontName = 'Palatino Linotype';
    p.FontSize = 10;
    grid(figproxa,'on')
    grid(figproxa,'minor')
    hold on
    filename = sprintf('Prox%d.png',ii);
    filename = strcat(outputfolder_trial,filename);
    set(figprox,'color','w');
    set(figproxa, 'Color', 'white');
    set(figproxa,'FontWeight','bold');
    set(figproxa,'FontName','Palatino Linotype');
    set(figproxa,'FontSize',10);
    set(figprox,'Renderer', 'opengl');
    exportgraphics(figprox,filename,'Resolution',600)
end
return