function [batch,batch_s] = create_batches(starts,goals,wd,ws,num_workers)
% Find sizes of parameter vectors
[n,~] = size(starts); 
[m,~] = size(goals);
o = length(wd);
p = length(ws);
% Find total number of test points
num_sim = n*m*o*p;
% Find ratios of test points for each worker
r = rem(num_sim,num_workers);
batch_size = floor(num_sim/num_workers);
for i = 1:1:num_workers
    if r > 0
        batch_s(i) = batch_size + 1;
        r = r - 1;
    else
        batch_s(i) = batch_size;
    end
end
% Create a parameter matrix of all the test points 
ind = 1;
for i = 1:1:n
    for j = 1:1:m
        for k = 1:1:o
            for ii = 1:1:p
                param(ind,:) = [starts(i,:) goals(j,:) wd(k) ws(ii)];
                ind = ind + 1 ;
            end
        end
    end
end
n = ind-1;
l = ind-1;
out = randperm(n,l);
param_new = param(out,:);
s = 1;
batch = zeros(max(batch_s),6,num_workers);
a = zeros(max(batch_s),6);
for i = 1:1:num_workers
%     s:sum(batch_s(1:i))
   a(1:batch_s(i),1:6) = param_new(s:sum(batch_s(1:i)),:);
   batch(1:batch_s(i),1:6,i) = a(1:batch_s(i),1:6);
   s = s + batch_s(i);
end
return