function [A,C,G,N,wd,ws] = compile_metric_arrays(files,outputfolder)
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% read file name and extract conditions used for sim run
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ind = 1;
for i = 5:5:length(files)
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% 
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    filename = sprintf('/data_perf/%s',files(i).name);
    filename = strcat(outputfolder,filename);
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% 
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    [wsstr,wdstr,g,s] = extract_name_plotting2(filename);
    wd(ind) = str2double(wdstr);
    ws(ind) = str2double(wsstr);
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% 
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    fid = fopen(filename,'r');
    dump = textscan(fid,'%s %s %s %s',1);
    ccc = textscan(fid,'%s %s %s %s',1);
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% 
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    A(ind) = str2double(cell2mat(ccc{1,1}));
    if A(ind) > 1
        A(ind) = nan;
    end
    C(ind) = str2double(cell2mat(ccc{1,2}));
    if C(ind) > 1
        C(ind) = nan;
    end
    G(ind) = str2double(cell2mat(ccc{1,3}));
    if G(ind) > 1
        G(ind) = nan;
    end
    N(ind) = str2double(cell2mat(ccc{1,4}));
    if N(ind) > 1
        N(ind) = nan;
    end
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% 
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    uw(ind) = ws(ind)*cosd(wd(ind));
    vw(ind) = ws(ind)*sind(wd(ind));
    ind = ind + 1;
    fclose(fid);
end
return