function Perf_analysis(outputfolder,spec_A,spec_C,spec_G,spec_N,outputfolder_trial)
[starts,goals] = setup_positions();
num_waypoints = zeros(1,1);
Aperf = zeros(1,1000);
Cperf = zeros(1,1000);
Gperf = zeros(1,1000);
Nperf = zeros(1,1000);
tic
folder = strcat(outputfolder,'/data/');
files = dir(folder);
for i = 3:2:length(files)
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% Initialize/reset intermediate variables
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    a = zeros(600/0.005,2,4);
    c = zeros(600/0.005,8);
    g = zeros(600/0.005,2,4);
    perpmag = zeros(1,600/0.005);
    proxmin = zeros(600/0.005,1);
    plannedmin = zeros(600/0.005,1);
    filename = sprintf('/data/%s',files(i).name);
    filename = strcat(outputfolder,filename);
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% read in the planned route
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    [final_route,num_waypoints,coord_sel] = prep_result_plan(filename);
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% read file name and extract the tested 
    %% conditions used for sim run
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    filename = sprintf('/data/%s',files(i+1).name);
    filename = strcat(outputfolder,filename);
    [wsstr,wdstr,~,~] = extract_name_plotting2(filename);
    wd = str2double(wdstr);
    ws = str2double(wsstr);
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% read in the response of the UAV
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    response = readmatrix(filename);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% Assign the response to intermediate 
    %% variables
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    toc
    % wtf am i doing here?
    response(1,11) = response(2,11);
    response(1,12) = response(2,12);
    response(1,13) = response(2,13);
    response(1,14) = response(2,14);
    response(1,15) = response(2,15);
    response(1,16) = response(2,16);
    response(1,2) = response(2,2);
    response(1,4) = response(2,4);
    response(1,3) = response(2,3);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% Segment the mission into straight and 
    %% turn sections
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    [segment_times_straight,...
        segment_times_turn,...
        segment_length_straight,...
        segment_length_turn] = segment_mission(response(:,14),response(:,15),response(:,1));
    [nnn,~] = size(segment_times_straight);
    for iii = 1:1:nnn
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% Apply cost functions
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        m = segment_length_straight(iii,1);
        n = segment_length_straight(iii,2);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Actuator Metric
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        a(m:n,1,1) = response(m:n,18); % lat
        a(m:n,2,1) = response(m:n,1); % time
        a(m:n,1,2) = response(m:n,19); % long
        a(m:n,2,2) = response(m:n,1); % time
        a(m:n,1,3) = response(m:n,20); % coll
        a(m:n,2,3) = response(m:n,1); % time
        a(m:n,1,4) = response(m:n,21); % pedal
        a(m:n,2,4) = response(m:n,1); % time
        [Aperf(iii),SaveIA,sumdifA(iii,:)] = actuator_perf_mex(a(m+1:n,:,:),spec_A);
        time = response(:,1);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Controller Metric
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        c(m:n,1) = response(m:n,17); % psiref
        c(m:n,2) = response(m:n,8); % uref
        c(m:n,3) = response(m:n,9); % vref
        c(m:n,4) = response(m:n,10); % wref
        c(m:n,5) = response(m:n,4); % psia
        c(m:n,6) = response(m:n,5); % u
        c(m:n,7) = response(m:n,6); %v
        c(m:n,8) = response(m:n,7); %w
        [Cperf(iii),SaveIC,sumdifC] = controller_perf_mex(c(m:n,:),spec_C,transpose(time(m:n)));
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Guidance metric
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        g(m:n,1,1) = response(m:n,11); % x
        g(m:n,2,1) = response(m:n,14); % xref
        g(m:n,1,2) = response(m:n,12); % y
        g(m:n,2,2) = response(m:n,15); % yref
        g(m:n,1,3) = response(m:n,13); % z
        g(m:n,2,3) = response(m:n,16); % zref
        g(m:n,1,4) = response(m:n,1); % time
        [perpmag(1,m:n)] = guidance_prep_mex(g(m:n,:,:),g(m:n,2,1),g(m:n,2,2),g(m:n,2,3));
        [Gperf(iii),SaveIG] = guidance_perf_mex(perpmag(1,m:n-2),spec_G,g(m:n-2,1,4));
        for ii =1:1:length(SaveIG)
              cost_function_progress(iii,ii) = sum(SaveIG(1:ii))/(time(m+ii)-time(m));    
              time_intervals(iii,ii) = time(m+ii);
        end
        segment_length(iii) = length(SaveIG);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Navigation metric
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        spos = [starts(1,1) starts(1,2) 0];
        gpos = [goals(1,1) goals(1,2) 0];
        n = n-1;
        %         [dot,pdot] = direction_of_travel(g(g(m:n,:,:),cc(m:n,:));
        [proxmin(m:n),plannedmin(m:n)] = navigation_prep_v0_mex(g(m:n,:,:),spos,gpos,coord_sel,final_route(1,1:num_waypoints));
        [Nperf(iii),SaveIN,timeO] = navigation_perf_mex(proxmin(m:n),plannedmin(m:n),spec_N,g(:,1,4));
    end
%     ACost_Progress = 
    Aperfmax = max(Aperf(1:nnn));
    Cperfmax = max(Cperf(1:nnn));
    Gperfmax = max(Gperf(1:nnn));
    Nperfmax = max(Nperf(1:nnn));
    Aperf = zeros(1,1000);
    Cperf = zeros(1,1000);
    Gperf = zeros(1,1000);
    Nperf = zeros(1,1000);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% Save output to file
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Save cost function progress
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    filename = sprintf('/data_perf/s_%s_%s_g_%s_%s_wd_%s_ws_%s_cost.txt',num2str(starts(1,1))...
        ,num2str(starts(1,2))...
        ,num2str(goals(1,1))...
        ,num2str(goals(1,2))...
        ,num2str(wd)...
        ,num2str(ws));
    filename = strcat(outputfolder_trial,filename);
    fid = fopen(filename,'w');
    writematrix(cost_function_progress,filename,'Delimiter','tab');
    fclose(fid);
        filename = sprintf('/data_perf/s_%s_%s_g_%s_%s_wd_%s_ws_%s_time_interval.txt',num2str(starts(1,1))...
        ,num2str(starts(1,2))...
        ,num2str(goals(1,1))...
        ,num2str(goals(1,2))...
        ,num2str(wd)...
        ,num2str(ws));
    filename = strcat(outputfolder_trial,filename);
    fid = fopen(filename,'w');
    writematrix(time_intervals,filename,'Delimiter','tab');
    fclose(fid);
        filename = sprintf('/data_perf/s_%s_%s_g_%s_%s_wd_%s_ws_%s_segment_length.txt',num2str(starts(1,1))...
        ,num2str(starts(1,2))...
        ,num2str(goals(1,1))...
        ,num2str(goals(1,2))...
        ,num2str(wd)...
        ,num2str(ws));
    filename = strcat(outputfolder_trial,filename);
    fid = fopen(filename,'w');
    writematrix(segment_length,filename,'Delimiter','tab');
    fclose(fid);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Save performance metric
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    filename = sprintf('/data_perf/s_%s_%s_g_%s_%s_wd_%s_ws_%s_perf.txt',num2str(starts(1,1))...
        ,num2str(starts(1,2))...
        ,num2str(goals(1,1))...
        ,num2str(goals(1,2))...
        ,num2str(wd)...
        ,num2str(ws));
    filename = strcat(outputfolder_trial,filename);
    fid = fopen(filename,'w');
    fprintf(fid,'Aperf \t Cperf \t Gperf \t Nperf \n');
    fprintf(fid,'%f \t %f \t %f \t %f \n',Aperfmax,Cperfmax,Gperfmax,Nperfmax);
    fclose(fid);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % save intermediate variables
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    filename = sprintf('/data_perf/s_%s_%s_g_%s_%s_wd_%s_ws_%s_analysis.txt',num2str(starts(1,1))...
        ,num2str(starts(1,2))...
        ,num2str(goals(1,1))...
        ,num2str(goals(1,2))...
        ,num2str(wd)...
        ,num2str(ws));
    filename = strcat(outputfolder_trial,filename);
    analysis(1:n-1,1) = proxmin(1:n-1);
    analysis(1:n-1,2) = plannedmin(1:n-1);
    analysis(1:n-1,3) = perpmag(1:n-1);
    writematrix(analysis(1:n-1,:),filename,'Delimiter','tab');
    fclose all;
    clearvars segment_length time_intervals cost_function_progress
end
return