function [int_u,int_v,int_w,uw,vw,ww] = set_initial_vel(ws,wd,int_psi,int_thetatrim,int_phitrim)
% rotate initial inertial velocities onto body frame
uw = -ws*cosd(wd)*1.68781; %knots to f/s
vw = -ws*sind(wd)*1.68781; %knots to f/s
ww = 0;
% vec = [uw vw];
cthe = cos(int_thetatrim);
cpsi = cos(int_psi);
cphi = cos(int_phitrim);
sthe = sin(int_thetatrim);
spsi = sin(int_psi);
sphi = sin(int_phitrim);
R = [cthe*cpsi                ,cthe*spsi                  ,-sthe;
    -cphi*spsi+sphi*sthe*cpsi   ,cphi*cpsi+sphi*sthe*spsi   ,sphi*cthe;
    sphi*spsi+cphi*sthe*cpsi    ,-sphi*cpsi+cphi*sthe*spsi  ,cphi*cthe];
vb = [uw; vw; ww];
vi = R*vb;
int_u = -vi(1);
int_v = -vi(2);
int_w = -vi(3);
end