function [A,B,C,D,E,k,...
    int_x,int_y,int_z,...
    int_u,int_v,int_w,...
    int_phitrim,int_thetatrim,int_psi,...
    Abase,Bbase,trimbase,kbase,op_points,...
    fwda,wsa,wda,...
    int_lat,int_long,int_coll,int_pedal,...
    route,coord,Num_Way_Points,...
    start_direction,end_direction,start_speed,end_speed,change_time] = set_conditions(starts,goals,wd,ws)
% ws = 10 ; %knots
% wd = 345; %deg
% starts = [30 25];
% goals = [80 117.5];
% set environment
[ws,wd,start_direction,end_direction,start_speed,end_speed,change_time] = set_environ(ws,wd);

% set planning conditions
[cond] = set_cond(start_direction,start_speed);

% plan route
[final_route,coord,Num_Way_Points,route,goals,starts] = set_plan(goals(:),starts(:),cond);

% Load linear models, gains and trims states
load('Abase.mat')
load('Bbase.mat')
load('trimbase.mat')
load('kbase.mat')
load('op_points.mat')
% Set linear operating points
wsa = [0:5:40]; %knots
wda = [0:30:330]; %deg
fwda = [-20:5:40]; %knots
% calc wind velocities

% set starting position
int_x = starts(1);
int_y = starts(2);
int_z = 0;
% set intial conditions of linear model deltas
E = [0 0 0 0 0 0 0 0 0];
int_psi = calc_heading(ws,wd,goals,starts);

% [int_u,int_v,int_w] = calc_int_vel(int_psi,ws,wd);

[int_phitrim,int_thetatrim,int_lat,int_long,int_coll,int_pedal] = set_int_trim(wd,int_psi,ws,fwda,wsa,wda,trimbase);

U = 0;
[A,B,C,D] = set_A_B_Mat(Abase,Bbase,fwda,wsa,wda,ws,wd,U,int_psi,op_points);

k(:,:) = kbase(1,1,1,:,:);
% k = set_gains(kbase,fwda,wsa,wda,ws,wd,int_psi);

[int_u,int_v,int_w,uw,vw,ww] = set_initial_vel(ws,wd,int_psi,int_thetatrim,int_phitrim);

plot_start_cond(route,coord,...
    int_thetatrim,int_psi,int_phitrim,...
    uw,vw,ww,...
    int_u,int_v,int_w)
end
% end

% return