function [A,B,C,D] = set_A_B_Mat(Abase,Bbase,fwda,wsa,wda,ws,wd,U,int_psi,op_points)
% U = 0;
% set the initial A and B matrices
dif = wd-rad2deg(int_psi);
wd = 0;
if dif < 0
    wd = 360 + dif    ;
elseif dif > 0
    wd = dif;
end
A = zeros(9,9);
B = zeros(9,4);
UU = zeros(9,9);
wsws = zeros(9,9);
wdwd = zeros(9,9);
roww = zeros(9,9);
coll = zeros(9,9);
% [fwdbase,wsbase,wdbase] = meshgrid(fwda,wsa,wda);
[n,m,o,~,~] = size(Abase);
a = zeros(n,m,o,9,9);
b = zeros(n,m,o,9,4);

wd = wind_heading_stitch_convention(wd);
[Iwda,wdsample] = find_wd_interval(wd,wda,op_points);
Ifwda = find_fwd_interval(U,fwda,op_points);
Iwsa = find_ws_interval(ws,wsa,op_points);
Iwsan = length(Iwsa);
Iwdan = length(Iwda);
Ifwdan = length(Ifwda);
for i = 1:1:9
    for j = 1:1:9
        UU(i,j) = U;
        wsws(i,j) = ws;
        wdwd(i,j) = wd;
        roww(i,j) = i;
        coll(i,j) = j;
    end
end
a(1:Ifwdan,1:Iwsan,1:Iwdan,:,:) = Abase(Ifwda(1):Ifwda(end),...
    Iwsa(1):Iwsa(end),...
    Iwda,...
    :,:);
F = griddedInterpolant({fwda(Ifwda(1):Ifwda(end)),...
    wsa(Iwsa(1):Iwsa(end)),...
    wdsample,...
    1:9,...
    1:9},...
    a(1:Ifwdan,1:Iwsan,1:Iwdan,...
    :,...
    :),...
    'cubic');
A(:,:) = F(UU,wsws,wdwd,roww,coll);
b(1:Ifwdan,1:Iwsan,1:Iwdan,:,:) = Bbase(Ifwda(1):Ifwda(end),...
    Iwsa(1):Iwsa(end),...
    Iwda,...
    :,...
    :);
F = griddedInterpolant({fwda(Ifwda(1):Ifwda(end)),...
    wsa(Iwsa(1):Iwsa(end)),...
    wdsample,...
    1:9,...
    1:4},...
    b(1:Ifwdan,1:Iwsan,1:Iwdan,...
    :,...
    :),...
    'cubic');
B(:,:) = F(UU(:,1:4),wsws(:,1:4),wdwd(:,1:4),roww(:,1:4),coll(:,1:4));
C = [1.0000  0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  ;0.0000  1.0000  0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  1.0000  0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  1.0000  0.0000  0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  1.0000  0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  0.0000  1.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  1.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  1.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  0.0000  1.0000];
D = [0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000  ;0.0000  0.0000  0.0000  0.0000 ];
end