function plot_start_cond(route,coord,...
    int_thetatrim,int_psi,int_phitrim,...
    uw,vw,ww,...
    int_u,int_v,int_w)
% close all
% figure
% figure('visible','off','Renderer','painters','Position',[0 40 1920 955 ])
x = coord(route,1);
y = coord(route,2);
plot(x,y,'linewidth',2,'color','k')
% xlim([0 100])
% ylim([0 100])
axis square
hold  on
cthe = cos(int_thetatrim);
cpsi = cos(int_psi);
cphi = cos(int_phitrim);
sthe = sin(int_thetatrim);
spsi = sin(int_psi);
sphi = sin(int_phitrim);
R = [cthe*cpsi                ,cthe*spsi                  ,-sthe;
    -cphi*spsi+sphi*sthe*cpsi   ,cphi*cpsi+sphi*sthe*spsi   ,sphi*cthe;
    sphi*spsi+cphi*sthe*cpsi    ,-sphi*cpsi+cphi*sthe*spsi  ,cphi*cthe];
vb = [int_u; int_v; int_w];
vi = transpose(R)*vb;
%%
quiver(coord(route(1),1),coord(route(1),2),vi(1),vi(2))
%%
quiver(coord(route(1),1),coord(route(1),2),uw,vw)
%%
quiver(coord(route(1),1),coord(route(1),2),10*cos(int_psi),10*sin(int_psi))
set(gca,'YDir','reverse')
camroll(90)
legend('route','indicated vel','wind vec','int psi','Location','northeastoutside')


xlabel('+north')
ylabel('+east')
hold on
return