function psi = calc_heading_no_wind(goals,starts)
v = [goals(1)-starts(1) goals(2)-starts(2)];
% convert to unit vector
vmag = sqrt(v(1)^2 + v(2)^2);
e = [0 0];
if vmag ~= 0
e(1) = v(1)/vmag;
e(2) = v(2)/vmag;
else
    e = [1 1];
end
A = e;
mag = sqrt(A(1)*A(1)+A(2)*A(2));
B = [1,0];
% tol = 0.001;
CCC = dot(A,B);
psi = 0;
if A(1) >= 0 && A(2) >= 0 %northeast quadrant
    psi = acos(CCC/mag);
elseif A(1) <= 0 && A(2) >= 0 %southeast quadrant
    psi = acos(CCC/mag);
elseif A(1) >= 0 && A(2) <= 0 %northwest quadrant
    psi = -acos(CCC/mag);
elseif A(1) <= 0 && A(2) <= 0 %southwest quadrant
    psi = -acos(CCC/mag);
end
% quiver(starts(1),starts(2),e(1),e(2))
% plot([goals(1) starts(1)],[starts(2) goals(2)])
% xlim([0 150])
% ylim([-150 0])
return