function int_psi = calc_heading(ws,wd,goals,starts)
psi = calc_heading_no_wind(goals,starts);
psi = rad2deg(psi);
psi = wind_heading_convention(psi);
% calc_heading
vd = 5*1.94384; %m/s into knots
vww = vd;
psiw = psi;
psiwold = psiw - 1;
vwold = vww + 0.1;
%%
wd = wind_heading_convention(wd);

gamma = wd; %deg
%% set method parameters
tol = 0.01;
stop = 0;
max_it = 1000;
it = 1;
% tic
while stop == 0
    % calc derivatives
    f11prime = (func1(vwold,psiw,ws,psi,gamma,vd)-func1(vww,psiw,ws,psi,gamma,vd))/(vwold-vww);
    f12prime = (func1(vww,psiwold,ws,psi,gamma,vd)-func1(vww,psiw,ws,psi,gamma,vd))/(psiwold-psiw);
    f21prime = (func2(vwold,psiw,ws,psi,gamma)-func2(vww,psiw,ws,psi,gamma))/(vwold-vww);
    f22prime = (func2(vww,psiwold,ws,psi,gamma)-func2(vww,psiw,ws,psi,gamma))/(psiwold-psiw);
    % construct jacobian
    DD = [f11prime f12prime;
        f21prime f22prime];
    % construct function output vector
    xx = [func1(vwold,psiwold,ws,psi,gamma,vd);
        func2(vwold,psiwold,ws,psi,gamma)];
    % set current best guess
    vk = [vwold;
        psiwold];
    % replace old estimates
    vwold = vww;
    psiwold = psiw;
    % calculate new best guess
    new = vk - 0.05*inv(DD)*xx;
    vww = new(1);
    psiw = new(2);
    % calc function outputs
    ub = func1(vww,psiw,ws,psi,gamma,vd);
    vb = func2(vww,psiw,ws,psi,gamma);
    %check to see if root is found
    if abs(ub) <= tol && abs(vb) <= tol
        stop = 1 ;
        % check if output is nan or max iterations  reached
    elseif it >= max_it || isnan(psiw)
        stop = 1;
    else
        it = it + 1;
    end
end
% calc difference between wind heading and direction of travel
dif = abs(psi-psiw);
% if greater than 45, leave wind conpensation up to roll and pitch
if dif >= 60 || isnan(psiw)
    % fix heading to 45 from direction of travel
    if psiw<psi
        psiw = psi-60;
    elseif psiw>psi
        psiw = psi+60;
        %     else
        %         psiw = psi;
    end
end
% if psiw<0
%     psiw = 360-abs(psiw);
% end
% psiw = psi
int_psi = deg2rad(psiw);
    function ub = func1(vw,psiw,ws,psi,gamma,vd)
        diff = abs(psi-gamma);
        if diff > 90
            ub = vw*cosd(psi-psiw) + ws*cosd(gamma-psi) - vd;
        else
            ub = vw*cosd(psi-psiw) - ws*cosd(gamma-psi) - vd;
        end
    end

    function vb = func2(vw,psiw,ws,psi,gamma)
        vb = vw*sind(psi-psiw) + ws*sind(gamma-psi);
    end
end