function [grid,obj,wind] = setup(grid_spacing,cond)
obj.num_obj = 0;
obj.type = 0;
obj.num_types = 0;
obj.circle_centre = [0,0];
obj.circle_rad1 = 0;
obj.circle_rad2 = 0;
obj.theta = 0;
obj.vertices(1,:) = [0,0];
obj.vertices(2,:) = [0,0];
obj.vertices(3,:) = [0,0];
obj.vertices(4,:) = [0,0];
obj.com_x = 0;
obj.com_y = 0;
% Settings for Grid
grid.grid_spacing = grid_spacing;
grid.grid_x = 50:grid.grid_spacing:180;
grid.grid_y = 50:grid.grid_spacing:180;
grid.grid_z = 0:grid.grid_spacing:235;
% Specification of objects by user
% circles

% vc(1).v = [8 10];
% vcr(1).r1 = 1.5;
% vcr(1).r2 = 1.5;
% vc(1).theta = 0;
% 
% vc(2).v = [5 10];
% vcr(2).r1 = 0.5;
% vcr(2).r2 = 0.5;
% vc(2).theta = 45;

% vc(3).v = [8 2];
% vcr(3).r1 = 0.75;
% vcr(3).r2 = 0.75;
% vc(3).theta = 45;

% vc(4).v = [6 6];
% vcr(4).r1 = 0.5;
% vcr(4).r2 = 1;
% vc(4).theta = 45;

% quads
v(1).vec = [75 75                     ;75 91;87 91;87 75 ];
v(2).vec = [75 109                   ;75 125;87 125;87 109];
v(3).vec = [75 143                   ;75 159;87 159;87 143];

v(4).vec = [133 75                   ;133 91;145 91;145 75];
v(5).vec = [133 109                ;133 125;145 125;145 109];
v(6).vec = [133 143              ;133 159;145 159;145 143  ];
% Settings for object
obj(1).num_types = 2;
% exist vc
if exist('vc','var') == 0
    vc.v = 0;
    obj(1).num_obj = length(v);
    ind = 1;
    for i = 1:1:length(v)
        obj(ind).type = 2;
        ind = ind +1;
    end
    obj(1).num_types = 1;
elseif exist('v','var') == 0
    v.vec = 0;
    obj(1).num_obj = length(vc);
    ind = 1;
    for i = 1:1:length(vc)
        obj(ind).type = 1;
        ind = ind +1;
    end
    obj(1).num_types = 1;
elseif exist('vc','var') == 0 && exist('v','var') == 0
    disp('No objects have been displayed')
    return
else
    obj(1).num_obj = length(v)+length(vc);
    ind = 1;
    for i = 1:1:length(vc)
        obj(ind).type = 1;
        ind = ind +1;
    end
    for i = 1:1:length(v)
        obj(ind).type = 2;
        ind = ind +1;
    end
    obj(1).num_types = 2;
end
if exist('vcr','var') == 0
    vcr.r = 0;
end
% return
% obj(1).num_obj = length(v)+length(vc);

% return
indc = 1;
indq = 1;
for i = 1:1:obj(1).num_obj
    obj(i).num_types = obj(1).num_types;
    obj(i).num_obj = obj(1).num_obj;
    % Circle
    if obj(i).type == 1
        obj(i).circle_centre = vc(indc).v;
        obj(i).circle_rad1 = vcr(indc).r1;
        obj(i).circle_rad2 = vcr(indc).r2;
        obj(i).theta = vc(indc).theta;
        indc = indc + 1;
        % quadrillateral
    else if obj(i).type == 2
            obj(i).vertices(1,:) = v(indq).vec(1,:);
            obj(i).vertices(2,:) = v(indq).vec(2,:);
            obj(i).vertices(3,:) = v(indq).vec(3,:);
            obj(i).vertices(4,:) = v(indq).vec(4,:);
            obj(i).com_x = (obj(i).vertices(1,1) + obj(i).vertices(2,1) + obj(i).vertices(3,1) + obj(i).vertices(4,1))/4;
            obj(i).com_y = (obj(i).vertices(1,2) + obj(i).vertices(2,2) + obj(i).vertices(3,2) + obj(i).vertices(4,2))/4;
            indq = indq + 1;
        end
    end
end
wind.speed = cond.world.wind_speed;%knots
wind.direction = cond.world.wind_direction ;%deg to north, clockwise
wind.direction = 90-wind.direction;
return