function [dist,prox,risk] = route_perf(route,coord_sel,goal,position,obj,current_risko,current_riskw)
risk = 0;
[nnn,mmm] = size(route);
for j = 1:1:nnn
    count = 1;
    for i = 1:1:length(route(nnn,:))
        if route(j,i) == 0
            count = count - 1;
            break
        else
            count = count + 1;
        end
    end
    for i = 1:1:count
        xref(i) = coord_sel(route(j,i),1);
        yref(i) = coord_sel(route(j,i),2);
    end
    dist(j) = 0;
    for i = 1:1:count-1
        p1 = xref(i+1) - xref(i);
        p2 = yref(i+1) - yref(i);
        dist(j) = dist(j) + sqrt(p1^2+p2^2);
    end
    num_intervals = 1000;
    interval = dist(j)/num_intervals;
    posx = zeros(1,num_intervals);
    posy = zeros(1,num_intervals);
    posz = zeros(1,num_intervals);
    ind = 1;
    posx(1,1) = xref(ind);
    posy(1,1) = yref(ind);
    posz(1,1) = 0;
    for i =1:1:num_intervals-1
        if posx(i) >= min([xref(ind+1) xref(ind)]) && posx(i) <= max([xref(ind+1) xref(ind)]) && posy(i) >= min([yref(ind+1) yref(ind)]) && posy(i) <= max([yref(ind+1) yref(ind)])
        else
            if ind + 1 == count
                break
            else
                ind = ind + 1;
                posx(i) =  xref(ind);
                posy(i) = yref(ind);
            end
        end
        p1 = xref(ind+1) - xref(ind);
        p2 = yref(ind+1) - yref(ind);
        d = sqrt(p1^2+p2^2);
        e1 = p1 / d;
        e2 = p2 / d;
        posx(i+1) = posx(i) + interval*e1;
        posy(i+1) = posy(i) + interval*e2;
        posz(i+1) = 0;
    end
    g(1,:) = posx;
    g(2,:) = posy;
    g(3,:) = posz;
    [proxmin(j,:),v,xr,yr,x,y] = navigation_prep(g,position,goal,coord_sel,route(j,:),obj,count);
    prox(j) = min(proxmin(j,:));
    clearvars xref yref

end
[N,M] = size(route);
for j = 1:1:N
    for i = 1:1:M-1
        if route(j,i+1) == 0
            break
        end
    end
    risko_sum(j) = sum(current_risko(j,1:i));
    riskw_sum(j) = sum(current_riskw(j,1:i));
    risk(j) = risko_sum(j) + riskw_sum(j);
end

return