function disp_shape(obj)
%% This program displays the specified shape and sizd of the world to be 
%% operated in.
for i = 1:1:obj(1).num_obj
    %% Display circles
    if obj(i).type == 1
        h = obj(i).circle_centre(1);
        k = obj(i).circle_centre(2);
        r1 = obj(i).circle_rad1;
        r2 = obj(i).circle_rad2;
        theta = obj(i).theta;
        n = 0:5:360;
        for ii = 1:1:length(n)
            x(ii) = r1*cosd(n(ii));
            y(ii) = r2*sind(n(ii));
        end
        for ii = 1:1:length(n)
        xp(ii) = x(ii)*cosd(theta) + y(ii)*sind(theta) + h;
        yp(ii) = -x(ii)*sind(theta) + y(ii)*cosd(theta) + k;
        end
        a = zeros(length(x));
        for ii = 1:1:length(x)-1
            a(ii+1,ii) = 1;
        end
        gplot(a,[transpose(xp) transpose(yp)],'-ok')
        axis square
        hold on
    %% Quadrilateral
    else
        coord(1,:) = obj(i).vertices(1,:);
        coord(2,:) = obj(i).vertices(2,:);
        coord(3,:) = obj(i).vertices(3,:);
        coord(4,:) = obj(i).vertices(4,:);
        coord(5,:) = [obj(i).com_x  obj(i).com_y];
        A = zeros(5,5) ;
        A(1,:) = [0 1 0 0 0];
        A(2,:) = [0 0 1 0 0];
        A(3,:) = [0 0 0 1 0];
        A(4,:) = [1 0 0 0 0];
        A(5,:) = [1 1 1 1 0];
        gplot(A,coord,'-ok')
        set(findall(gcf,'type','line'),'LineWidth',2)
        axis square
        hold on
    end
end


return