function [open_new,current,cost_new,current_cost,current_risko,current_riskw,risko_new,riskw_new,costh_new,costr_new] = sort_routes(costh,open,cost,current,current_cost,N,M,current_risko,current_riskw,risko,riskw,costr)
% initialize the 'open_new' and 'cost_new'
n = measure_length_mat(open,N);
nlast = measure_length(current);
mlast = M;
for i = 1:1:M
    if open(n,i) == 0
        mlast = i-1;
        break
    end
end
if current(nlast) == open(n,mlast)
    open(n,:) = zeros(1,N);
end


[open_end,cost_end,costh_end,risko_end,riskw_end,costr_end] = remove_duplicate_destinations(open,costh,cost,risko,riskw,N,M,costr);
n = measure_length_mat(open_end,N);
% sort the costs of all the routes based on distance cost
[~,I] = sort(costh_end(1:n),'descend');
% reorder the 'open' and 'cost' matrices based on the sorted list.
[open_new,cost_new,risko_new,riskw_new,costh_new,costr_new] = reorder_oc_fast(n,I,open_end,cost_end,risko_end,riskw_end,N,M,costh_end,costr_end);
[current,current_cost,current_risko,current_riskw,cost_new,open_new,risko_new,riskw_new] = assign_current(M,n,open_new,cost_new,risko_new,riskw_new,current,current_cost,current_risko,current_riskw);
return