function [new,cost,closed,risko,riskw] = expansion(current,A,d,closed,Ro,Rw)
%%%%%%%%%%%%%%%%%%%%
% This subroutine takes the current node
% and finds the neighbours of it and
% saves the info in the 'new' vector.
%%%%%%%%%%%%%%%%%%%%
% Measure the length of the closed list
m = measure_length_mex(closed);
% Measure the length of the current route list
n = measure_length_mex(current);
% Assign the last element of the current route to the closed list
closed(m+1) = current(n);
% Initialize the new and cost matrices
new = zeros(1,m);
cost = zeros(1,m);
risko = zeros(1,m);
riskw = zeros(1,m);
% Starts new counter
[AA,I] = sort(A(current(n),:),'descend');
for i = 1:1:length(A(1,:))
    if AA(i) == 0
        mm = i-1;
        break
    end
end
% [AAA,II] = sort(closed(1:m+1));
ind = 1;
for i = 1:1:mm
    no = 0;
    % If the node is not itself
    if current(n) ~= I(i)
        no = find_closed_mex(closed,I(i),m);
        % If the node is not on the closed list
        if no == 0
            % Assigns the node to the new list
            new(ind) = I(i);
            % Assigns the cost to the cost list
            cost(ind) = d(current(n),I(i));
            risko(ind) = Ro(current(n),I(i)); 
            riskw(ind) = Rw(current(n),I(i));
            % Increments the counter
            ind = ind + 1;
        end
    end
end
return