function [openi,costi,riskoi,riskwi,n,num] = combine(new,open,cost,costnew,current,current_cost,N,M,risko,riskw,riskonew,riskwnew,current_risko,current_riskw)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This sub routine creates a new set of possible routes by adding the 'new'
% nodes onto the end of the current route.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% finds the number of new nodes
n = measure_length_mex(new);
% finds the number of routes in the open matrix
num = measure_length_mex(transpose(open(:,1)));
% Assigns the existing part of the current route to the end of the open and
% cost matrices
mm = measure_length_mex(current);
for i = 1:1:n
    for j = 1:1:mm
        open(num + i,j) =  current(1,j);
        cost(num + i,j) =  current_cost(1,j);
        risko(num + i,j) = current_risko(1,j);
        riskw(num + i,j) = current_riskw(1,j);
    end
end
% adding the new nodes onto the end of the open list.
ind = 1;
for j = num+1:1:num+n
    for i = 1:1:N
        % if there is space in the open lists for a given row
        if open(j,i) == 0
            % assign cost of moving to new node to the cost matrix 
            cost(j,i) = costnew(ind);
            risko(j,i) = riskonew(ind);
            riskw(j,i) = riskwnew(ind);
            % add the new node to the end of a current route
            open(j,i) = new(ind);
            break
        end
    end
    % Increment new node counter
    ind = ind + 1;
end
openi = open;
costi = cost;
riskoi = risko;
riskwi = riskw;
return