function [open_end,cost_end,costh_end,risko_end,riskw_end,costr_end] = remove_duplicate_destinations(open,costh,cost,risko,riskw,N,M,costr)
% Intialize variables
open_re = zeros(N,1);
cost_re = zeros(N,1);
risko_re = zeros(N,1);
riskw_re = zeros(N,1);
% Find the number of routes in open list
n = measure_length_mat_mex(open,N);
m = measure_rows_mex(open,n,M);
% re-org open and cost list to have the last node at the start of the list in each row
for i =  1:1:n
    open_re(i,1) = open(i,m(i));
    cost_re(i,1) = cost(i,m(i));
    risko_re(i,1) = risko(i,m(i));
    riskw_re(i,1) = riskw(i,m(i));
end
% sort open list to find routes with the same end goal.
[~,I] = sort(open_re(1:n,1));
% if a duplicate end nodes exist, remove all but the least costly
% bb = false(2000,1);
bb = duplicate_check(open_re,I,costh,n);
% create new lists with the duplicates removed
[open_end,cost_end,costh_end,risko_end,riskw_end,costr_end] = reorder(n,bb,m,I,open,cost,costh,N,M,risko,riskw,costr);
return