function [x,y,a,b] = calc_intercept(test1,edge,v2,com)
% if the gradient is infinite, a different method is is used to
% find the intercept between the two lines.
test = edge;
if test1(1) == 0
    % Find equation of line between vertices
    m1 = inf;
    m2 = test(2)/test(1); % gradient
    c2 = v2(2) - m2*v2(1); % intersection
    % Find intercept
    x = com(1); % x point of intercept
    y = m2*x + c2; % y point of intercept
    
elseif test(1) == 0
    m1 = test1(2)/test1(1); % gradient
    c1 = com(2) - m1*com(1); % intersection
    x = v2(1);
    y = m1*v2(1) + c1;
    m2 = inf;
else
    % Find equation of line between com and grid point
    m1 = test1(2)/test1(1); % gradient
    c1 = com(2) - m1*com(1); % intersection
    % Find equation of line between vertices
    m2 = test(2)/test(1); % gradient
    c2 = v2(2) - m2*v2(1); % intersection
    % Find intercept
    y = (-m2*c1+c2*m1)/(m1-m2); % y point of intercept
    if m1 == 0 % if gradient is very small
        x = (y-c2)/m2; % x point of intercept
    else
        x = (y-c1)/m1; % x point of intercept
    end
end
a = m1;
b = m2;
return