function [coord_sel,A,pc,pq,d,b] = grid_build(grid,obj)
%% This programs creates an intitial grid of points, removes those that are 
%% within the objects, and then connects the points while avoiding 
%% intersections
% Reassigns grid structure.
grid_x = grid.grid_x;
grid_y = grid.grid_y;
% grid_z = grid.grid_z;
%% Create an initial grid of points
n = length(grid_x)*length(grid_y);
ind = 1;
coord = zeros(n,2);
for i = 1:1:length(grid_x)
    for j = 1:1:length(grid_y)
        coord(ind,:) = [grid_x(i) grid_y(j)];
        ind = ind +1;
    end
end
%% Eliminate grid points that are within the objects 
[quad,circle,obj_newq,obj_newc] = setup_obj_struc(obj);
stop = 1;
i   = 1;
% creates initial truth array for point existance. They start as all
% existing
bc = ones(1,length(grid.grid_x)*length(grid.grid_y));
bq = ones(1,length(grid.grid_x)*length(grid.grid_y));
while stop == 1
    if i == 1 && circle == 1
        % removes points within circles
        bc = circle_obj(obj_newc,coord,n,grid);
    elseif i == 2 && quad == 1
        % removes points within quads
        bq = quad_obj(grid,obj_newq,coord,n);
    end
    i = i + 1;
    if i == 3
        stop = 0;
    end
end
% combines the circle and quad truth arrays.
b = true(n,1);
for i = 1:1:n
    if bc(i) == false || bq(i) == false
        b(i) = false;
    end
end
%% Create new grids coordinate vector
ind = 1;
coord_sel = zeros(sum(b),2);
for i = 1:1:n
    if b(i) == true
        coord_sel(ind,:) = coord(i,:);
        ind = ind + 1;
    end
end
% diagnostics: display grid points
% scatter(coord_sel(:,1),coord_sel(:,2))
%% Setup edge distributions
[pc,pq] = edge_dist(obj,obj_newc,obj_newq,grid,quad,circle);
%% Create connections matrix
[A,d] = create_conn(coord_sel,grid,pq,obj,obj_newc,obj_newq,quad,circle,b);
return