function [b] = quad_obj(grid,obj,coord,n)
%% This program finds and removes the points that are within the area draw
%% by the connection of the four vertices specified by the user. 
% extract info from strctures
m = obj(1).num_obj;
grid_spacing = grid.grid_spacing;
% Setup of variables
vertices_angle = zeros(4,1);
b = true(n,1);
com = zeros(1,2);
R  = zeros(1,m);
mag = zeros(1,4);
test1 = [0 0];
edge = [0 0];
v2 = [0 0];
% Set max spacing between points 
r  = 2*sqrt(grid_spacing^2 + grid_spacing^2);
% loops over the number of objects
for k = 1:1:m
    % extract centre of mass of object and vertices from structure
    com(1) = obj(k).com_x;
    com(2) = obj(k).com_y;
    vertices = obj(k).vertices;
    % Calc Vertices angle wrt to centre of mass of object
    for i = 1:1:4
        % Find vector between centre of mass of object and a vertex of that
        % object
        vec = [vertices(i,1)-com(1) vertices(i,2)-com(2)];
        % Calculates the angle of the vector to the y axis depending on
        % what quadrant the vertex is in with the origin at the centre of
        % mass
        vertices_angle(i) = calc_angle(vec);
    end
    % Sets the centre of mass for the object in question and sets up the
    % grid angle variables
    for i = 1:1:4
        vec = [vertices(i,1)-com(1) vertices(i,2)-com(2)];
        mag(i) = sqrt(vec(1)^2 + vec(2)^2);
    end
    R(k) = max(mag);
    grid_angle = zeros(n,1);
    for i = 1:1:n
        % Finds vector of centre of mass to grid point in question
        test1(1) = coord(i,1) - com(1);
        test1(2) = coord(i,2) - com(2);
        grid_magi = sqrt((test1(1))^2 + (test1(2))^2);
        % test if either of the grids points is within the circle.
        if grid_magi < (R(k)+r) %|| grid_magi < (R(k)+r)
            if test1(1) == 0 && test1(2) == 0
                b(i) = 0;
            else
                % Calculates the angle of the grid points to the y axis where the
                % centre of mass is the origin.
                grid_angle(i) = calc_angle(test1);
                % if the grid point is within the cone formed by two vertices and
                % the origin, then only on the edge formed by those two vertices is
                % considered. It makes it quicker.
                % 5 conditions in order:
                %                       -between the fourth and the first
                %                       -between the first and the second
                %                       -between the second and third + 360
                %                       -between the vertical and the third angle
                %                       -between the third angle and the fourth
                if (grid_angle(i) >= vertices_angle(4)) && (grid_angle(i) <= vertices_angle(1))
                    edge = vertices(1,:)-vertices(4,:);
                    v2 = vertices(4,:);
                elseif (grid_angle(i) >= vertices_angle(1)) && (grid_angle(i) <= vertices_angle(2))
                    edge = vertices(2,:)-vertices(1,:);
                    v2 = vertices(1,:);
                elseif (grid_angle(i) >= vertices_angle(2)) && grid_angle(i) <= (360 + vertices_angle(3))
                    edge = vertices(3,:)-vertices(2,:);
                    v2 = vertices(2,:);
                elseif (grid_angle(i) >= 0) && grid_angle(i) <= vertices_angle(3)
                    edge = vertices(3,:)-vertices(2,:);
                    v2 = vertices(2,:);
                elseif (grid_angle(i) >= vertices_angle(3)) && (grid_angle(i) <= vertices_angle(4))
                    edge = vertices(4,:)-vertices(3,:);
                    v2 = vertices(3,:);
                end
                [x,y] = calc_intercept(test1,edge,v2,com);
                % if length of vector between grid point and centre of mass is less
                % that the vector between intercept and centre of mass, remove
                % point.
                if sqrt(test1(1)^2+test1(2)^2) <= sqrt((x - com(1))^2+(y - com(2))^2)+grid_spacing*0.01%+grid_spacing
                    b(i) = 0;
                end
            end
            % Diagnostics: resultant grid
            % scatter(x,y)
            % scatter(coord(i,1),coord(i,2))
        end
    end
end
return