function [pc,pq] = edge_dist(obj,obj_newc,obj_newq,grid,quad,circle)
% creates a unifrom distribution of points along a line the same length of
% the edge between two vertices and then rotates it by the angle between
% the edge and the axis.
m = obj(1).num_obj;
o = obj_newc(1).num_obj;
% intialises variables
vertices_angle = zeros(1,4);
n = 0:5:360;
x = zeros(1,length(n));
y = zeros(1,length(n));
inter = struct('x',zeros(1,length(n)),'y',zeros(1,length(n)));
pc = repmat(inter,[4,o]);
pq = repmat(inter,[4,m]);
nt = length(0:.5*grid.grid_spacing:max([grid.grid_x grid.grid_y grid.grid_z]));
% loops over number of objects
for ii = 1:(obj_newc(1).num_obj):obj(1).num_types+(obj_newc(1).num_obj-1)
    if obj(ii).type == 1 && circle == 1
        for kk = 1:1:obj_newc(1).num_obj
            k = obj_newc(1).circle_centre(2);
            h = obj_newc(1).circle_centre(1);
            r1 = obj_newc(1).circle_rad1;
            r2 = obj_newc(1).circle_rad2;
            theta = 0;
            for i = 1:1:length(n)
                x(i) = r1*cosd(n(i));
                y(i) = r2*sind(n(i));
                pc(1,kk).x(i) = x(i)*cosd(theta)-y(i)*sind(theta)+h;
                pc(1,kk).y(i) = x(i)*sind(theta)+y(i)*cosd(theta)+k;
            end
        end
    elseif obj(ii).type == 2 && quad == 1
        for k = 1:1:obj_newq(1).num_obj
            % loops over number of vertices, always 4 for quadtrilaterals
            for i = 1:1:4
                % i vertex 4, from 1 to 4, else start at first and take next
                % vertex, setup this way for higher number of vertices in later
                % versions
                if i == 4
                    vec = [obj_newq(k).vertices(1,1)-obj_newq(k).vertices(4,1) obj_newq(k).vertices(1,2)-obj_newq(k).vertices(4,2)];
                else
                    vec = [obj_newq(k).vertices(i+1,1)-obj_newq(k).vertices(i,1) obj_newq(k).vertices(i+1,2)-obj_newq(k).vertices(i,2)];
                end
                vertices_angle(i) = calc_angle(vec);
                % creates uniform distribution with half grid spacing intervals
                xt = 0:.5*grid.grid_spacing:sqrt(vec(1)^2+vec(2)^2);
                for j = 1:1:length(xt)
                    % rotates point onto edge
                    pq(i,k).x(j) = xt(j)*cosd(vertices_angle(i)-90)+obj_newq(k).vertices(i,1);
                    pq(i,k).y(j) = -xt(j)*sind(vertices_angle(i)-90)+obj_newq(k).vertices(i,2);
                end
                % length of x changes, so clearing to prevent indexing error
                xt = zeros(1,nt);
            end
        end
    end
end
return