function b = circle_obj(obj,coord,n,grid)
%% This tests to see if points are within the objects 
% initialize variables
b = ones(n,1);
x = zeros(1,n);
y = zeros(1,n);
for j = 1:1:obj(1).num_obj
    % extract info from structure
    circle_centre = obj(j).circle_centre;
    r1  = obj(j).circle_rad1 ;
    r2  = obj(j).circle_rad2 ;
    theta = -obj(j).theta;
    % find the minimum and maximum of the elipse radii 
    mm = max([r1 r2]);
    mmin = min([r1 r2]);
    % for each point in teh starting grid
    for i = 1:1:n
        % find vector between the point and the centre of the circle
        test = circle_centre - coord(i,:);
        % calc magnitude of vector
        r = sqrt(test(1)^2+test(2)^2);
        % if the vector is smaller than the minimumm radii, then set the
        % truth value to zero
        if r <= mmin
            b(i) = 0;
        % else if the vector is less than the maximum radii, rotate point 
        % and circle centre and finds the angle of the point to north. Using
        % this angle the intersection point on the elipse is found.
        elseif r <= mm
            % rotate point
            x(i) =  coord(i,1)*cosd(theta)+ coord(i,2)*sind(theta);
            y(i) = -coord(i,1)*sind(theta)+ coord(i,2)*cosd(theta);
            % rotate circle
            c1 = circle_centre(1)*cosd(theta) + circle_centre(2)*sind(theta);
            c2 = -circle_centre(1)*sind(theta) + circle_centre(2)*cosd(theta);
            % Find new vector between the centre and point 
            test = [c1 c2] - [x(i) y(i)];
            % find angle of vector to north
            theta1 = calc_angle(test);
            % find magnitude of vector
            r = sqrt(test(1)^2+test(2)^2);
            % find intersect point
            xi = r1*cosd(theta1);
            yi = r2*sind(theta1);
            % if vector magnitude is less that intersection point magnitude
            % is less than, set truth array value to zero.
            if r <= r1*r2/sqrt(xi^2+yi^2)%+grid.grid_spacing
                b(i) = 0;
            end
        end
    end
    
end
% Disagnostic: resultant grid
% b = logical(b);
% scatter(coord(b,1),coord(b,2));
return