function [coord_lee,blx,bly,bl,nnn] = find_lee_grid(obj_newq,coord_sel,grid,grad,inter,px,py,wind,b)
bs=b;
alpha = wind.direction-90;
% meaure length of inputs
m = length(bs);
n = length(coord_sel);
N = length(grid.grid_x);
M = length(grid.grid_y);
% Initialize variables
coord_lee = zeros(n,2,obj_newq(1).num_obj);
rotx = zeros(1,m);
roty = zeros(1,m);
rotrotx = zeros(1,m);
rotroty = zeros(1,m);
gridvec = zeros(N*M,2);
leex = zeros(1,m);
leey = zeros(1,m);
bl = false(m,obj_newq(1).num_obj);
if grad(1,1) == inf
    in = 1; % start of index counter
    for i = 1:1:N % loops over the number of grid points in x dimension
        for j = 1:1:M % loops over the number of grid points in y dimension
            gridvec(in,1) = grid.grid_x(i);
            gridvec(in,2) = grid.grid_y(j);
            in = in + 1;
        end
    end
    for k = 1:1:obj_newq(1).num_obj
        blx(1,k) = min(px(:,k))-grid.grid_spacing*0.1;
        blx(2,k) = max(px(:,k))+grid.grid_spacing*0.1;
        bly(1,k) = min(py(:,k))-grid.grid_spacing*0.1;
        bly(2,k) = min(py(:,k))-grid.grid_spacing*0.1;
        xmin = min(px(:,k))-grid.grid_spacing*0.1;
        xmax = max(px(:,k))+grid.grid_spacing*0.1;
        ymin = min(py(:,k))-grid.grid_spacing*0.1;
        for i = 1:1:m
            if gridvec(i,1) > xmin && gridvec(i,1) < xmax && gridvec(i,2) > ymin
                coord_lee(i,1,k) = gridvec(i,1);
                coord_lee(i,2,k) = gridvec(i,2);
                bl(i,k) = true;
            end
        end
        nnn(k) = length(coord_lee(bl(:,k),1,k));
    end
elseif grad(1,1) == -inf
    in = 1; % start of index counter
    for i = 1:1:N % loops over the number of grid points in x dimension
        for j = 1:1:M % loops over the number of grid points in y dimension
            gridvec(in,1) = grid.grid_x(i);
            gridvec(in,2) = grid.grid_y(j);
            in = in + 1;
        end
    end
    for k = 1:1:obj_newq(1).num_obj
        blx(1,k) = min(px(:,k))-grid.grid_spacing*0.1;
        blx(2,k) = max(px(:,k))+grid.grid_spacing*0.1;
        bly(1,k) = min(py(:,k))-grid.grid_spacing*0.1;
        bly(2,k) = min(py(:,k))-grid.grid_spacing*0.1;
        xmin = min(px(:,k))-grid.grid_spacing*0.1;
        xmax = max(px(:,k))+grid.grid_spacing*0.1;
        ymin = min(py(:,k))-grid.grid_spacing*0.1;
        for i = 1:1:m
            if gridvec(i,1) > xmin && gridvec(i,1) < xmax && gridvec(i,2) < ymin
                coord_lee(i,1,k) = gridvec(i,1);
                coord_lee(i,2,k) = gridvec(i,2);
                bl(i,k) = true;
            end
        end
        nnn(k) = length(coord_lee(bl(:,k),1,k));
    end
else
    % start of loop
    for k = 1:1:obj_newq(1).num_obj %loops over the number of objects
        b = false(1,m);
        bb = false(1,m);
        % create vector of grid points
        in = 1; % start of index counter
        for i = 1:1:N % loops over the number of grid points in x dimension
            for j = 1:1:M % loops over the number of grid points in y dimension
                gridvec(in,1) = grid.grid_x(i);
                gridvec(in,2) = grid.grid_y(j);
                in = in + 1;
            end
        end
        % rotate grid by the wind angle
        for i = 1:1:m
            x = gridvec(i,1);
            y = gridvec(i,2);
            rotx(i) = x*cosd(alpha) + y*sind(alpha);
            roty(i) = -x*sind(alpha) + y*cosd(alpha);
        end
        % rotate vertices of objects
        rotpx(1) = px(1,k)*cosd(alpha) + py(1,k)*sind(alpha);
        rotpy(1) = -px(1,k)*sind(alpha) + py(1,k)*cosd(alpha);
        rotpx(2) = px(2,k)*cosd(alpha) + py(2,k)*sind(alpha);
        rotpy(2) = -px(2,k)*sind(alpha) + py(2,k)*cosd(alpha);
        % rotate lee lines
        rotinter1(1) = 0*cosd(alpha) + inter(1,k)*sind(alpha);
        rotinter1(2) = -0*sind(alpha) + inter(1,k)*cosd(alpha);
        rotinter2(1) = 0*cosd(alpha) + inter(2,k)*sind(alpha);
        rotinter2(2) = -0*sind(alpha) + inter(2,k)*cosd(alpha);
        % determine the back line of the objects lee
        lymax = max(rotpy);
        [lymin,I] = min(rotpy);
        lxmax = max(rotpx);
        lxmin = min(rotpx);
        if I == 1
            difx = rotpx(2) - rotpx(1);
            dify = rotpy(2) - rotpy(1);
            rotblx(1) = rotpx(I);
            rotblx(2) = rotpx(I)+difx;
            rotbly(1) = rotpy(I);
            rotbly(2) = rotpy(I);
        elseif I == 2
            difx = rotpx(1) - rotpx(2);
            dify = rotpy(1) - rotpy(2);
            rotblx(1) = rotpx(I)+difx;
            rotblx(2) = rotpx(I);
            rotbly(1) = rotpy(I);
            rotbly(2) = rotpy(I);
        end
        % rotate the backline back to un-rotated space
        blx(1,k) = rotblx(1)*cosd(-alpha) + rotbly(1)*sind(-alpha);
        bly(1,k) = -rotblx(1)*sind(-alpha) + rotbly(1)*cosd(-alpha);
        blx(2,k) = rotblx(2)*cosd(-alpha) + rotbly(2)*sind(-alpha);
        bly(2,k) = -rotblx(2)*sind(-alpha) + rotbly(2)*cosd(-alpha);
        % determine whether points are within the lee lines
        for i = 1:1:m
            if bs(i) == 1
                x = rotx(i);
                y = roty(i);
                if y>=lymin && x>=lxmin && x<=lxmax
                    b(i) = true;
                end
            end
        end
        % rotate the grid backline by its angle
        if rotpx(2)-rotpx(1) == 0
            angle = 0;
        else
            pm = (rotpy(2)-rotpy(1))/(rotpx(2)-rotpx(1));
            angle = atand(pm);
        end
        for i = 1:1:m
            x = rotx(i);
            y = roty(i);
            rotrotx(i) = x*cosd(angle) + y*sind(angle);
            rotroty(i) = -x*sind(angle) + y*cosd(angle);
        end
        % rotate the object vertices by the angle of the backline
        rotrotpx(1) = rotpx(1)*cosd(angle) + rotpy(1)*sind(angle);
        rotrotpy(1) = -rotpx(1)*sind(angle) + rotpy(1)*cosd(angle);
        rotrotpx(2) = rotpx(2)*cosd(angle) + rotpy(2)*sind(angle);
        rotrotpy(2) = -rotpx(2)*sind(angle) + rotpy(2)*cosd(angle);
        % determine whether the grid points are above the back line
        rotlymin = min(rotrotpy);
        for i = 1:1:m
            if bs(i) == 1
                x = rotrotx(i);
                y = rotroty(i);
                if y >= rotlymin
                    bb(i) = true;
                end
            end
        end
        % combine both grid binary and lee binary vectors
        bbb= false(1,m);
        for i = 1:1:m
            if b(i) == 1 && bb(i) == 1
                bbb(i) = true;
            end
        end
        bl(:,k) = bbb;
        % rotate the lee grid back by the wind angle
        for i = 1:1:m
            x = rotx(i);
            y = roty(i);
            leex(i) = x*cosd(-alpha) + y*sind(-alpha);
            leey(i) = -x*sind(-alpha) + y*cosd(-alpha);
        end
        % measure number of lee grid points for object
        nnn(k) = length(leex(bbb));
        % save lee grid points for object
        ind = 1;
        for i = 1:1:m
            if bbb(i) == 1 && bs(i) == 1
                coord_lee(ind,1,k) = gridvec(i,1);
                coord_lee(ind,2,k) = gridvec(i,2);
                ind = ind + 1;
                %         coord_lee(1:nnn(k),1,k) = transpose(leex(bbb));
                %     coord_lee(1:nnn(k),2,k) =  transpose(leey(bbb));
            end
        end
    end
end
return